// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.GlobalSchemaContractInner;
import com.azure.resourcemanager.apimanagement.models.GlobalSchemaContract;
import com.azure.resourcemanager.apimanagement.models.SchemaType;

public final class GlobalSchemaContractImpl
    implements GlobalSchemaContract, GlobalSchemaContract.Definition, GlobalSchemaContract.Update {
    private GlobalSchemaContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public SchemaType schemaType() {
        return this.innerModel().schemaType();
    }

    public String description() {
        return this.innerModel().description();
    }

    public Object value() {
        return this.innerModel().value();
    }

    public Object document() {
        return this.innerModel().document();
    }

    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public GlobalSchemaContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String schemaId;

    private String createIfMatch;

    private String updateIfMatch;

    public GlobalSchemaContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    public GlobalSchemaContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getGlobalSchemas()
            .createOrUpdate(resourceGroupName, serviceName, schemaId, this.innerModel(), createIfMatch, Context.NONE);
        return this;
    }

    public GlobalSchemaContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getGlobalSchemas()
            .createOrUpdate(resourceGroupName, serviceName, schemaId, this.innerModel(), createIfMatch, context);
        return this;
    }

    GlobalSchemaContractImpl(String name, com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new GlobalSchemaContractInner();
        this.serviceManager = serviceManager;
        this.schemaId = name;
        this.createIfMatch = null;
    }

    public GlobalSchemaContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    public GlobalSchemaContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getGlobalSchemas()
            .createOrUpdate(resourceGroupName, serviceName, schemaId, this.innerModel(), updateIfMatch, Context.NONE);
        return this;
    }

    public GlobalSchemaContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getGlobalSchemas()
            .createOrUpdate(resourceGroupName, serviceName, schemaId, this.innerModel(), updateIfMatch, context);
        return this;
    }

    GlobalSchemaContractImpl(GlobalSchemaContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.schemaId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "schemas");
    }

    public GlobalSchemaContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getGlobalSchemas()
            .getWithResponse(resourceGroupName, serviceName, schemaId, Context.NONE)
            .getValue();
        return this;
    }

    public GlobalSchemaContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getGlobalSchemas()
            .getWithResponse(resourceGroupName, serviceName, schemaId, context)
            .getValue();
        return this;
    }

    public GlobalSchemaContractImpl withSchemaType(SchemaType schemaType) {
        this.innerModel().withSchemaType(schemaType);
        return this;
    }

    public GlobalSchemaContractImpl withDescription(String description) {
        this.innerModel().withDescription(description);
        return this;
    }

    public GlobalSchemaContractImpl withValue(Object value) {
        this.innerModel().withValue(value);
        return this;
    }

    public GlobalSchemaContractImpl withDocument(Object document) {
        this.innerModel().withDocument(document);
        return this;
    }

    public GlobalSchemaContractImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
