// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.IdentityProviderContractInner;
import com.azure.resourcemanager.apimanagement.models.ClientSecretContract;
import com.azure.resourcemanager.apimanagement.models.IdentityProviderContract;
import com.azure.resourcemanager.apimanagement.models.IdentityProviderCreateContract;
import com.azure.resourcemanager.apimanagement.models.IdentityProviderType;
import com.azure.resourcemanager.apimanagement.models.IdentityProviderUpdateParameters;
import java.util.Collections;
import java.util.List;

public final class IdentityProviderContractImpl
    implements IdentityProviderContract, IdentityProviderContract.Definition, IdentityProviderContract.Update {
    private IdentityProviderContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String clientId() {
        return this.innerModel().clientId();
    }

    public String clientSecret() {
        return this.innerModel().clientSecret();
    }

    public IdentityProviderType typePropertiesType() {
        return this.innerModel().typePropertiesType();
    }

    public String signinTenant() {
        return this.innerModel().signinTenant();
    }

    public List<String> allowedTenants() {
        List<String> inner = this.innerModel().allowedTenants();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public String authority() {
        return this.innerModel().authority();
    }

    public String signupPolicyName() {
        return this.innerModel().signupPolicyName();
    }

    public String signinPolicyName() {
        return this.innerModel().signinPolicyName();
    }

    public String profileEditingPolicyName() {
        return this.innerModel().profileEditingPolicyName();
    }

    public String passwordResetPolicyName() {
        return this.innerModel().passwordResetPolicyName();
    }

    public String clientLibrary() {
        return this.innerModel().clientLibrary();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public IdentityProviderContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private IdentityProviderType identityProviderName;

    private String createIfMatch;

    private IdentityProviderCreateContract createParameters;

    private String updateIfMatch;

    private IdentityProviderUpdateParameters updateParameters;

    public IdentityProviderContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    public IdentityProviderContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getIdentityProviders()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, identityProviderName, createParameters,
                createIfMatch, Context.NONE)
            .getValue();
        return this;
    }

    public IdentityProviderContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getIdentityProviders()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, identityProviderName, createParameters,
                createIfMatch, context)
            .getValue();
        return this;
    }

    IdentityProviderContractImpl(IdentityProviderType name,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new IdentityProviderContractInner();
        this.serviceManager = serviceManager;
        this.identityProviderName = name;
        this.createIfMatch = null;
        this.createParameters = new IdentityProviderCreateContract();
    }

    public IdentityProviderContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new IdentityProviderUpdateParameters();
        return this;
    }

    public IdentityProviderContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getIdentityProviders()
            .updateWithResponse(resourceGroupName, serviceName, identityProviderName, updateIfMatch, updateParameters,
                Context.NONE)
            .getValue();
        return this;
    }

    public IdentityProviderContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getIdentityProviders()
            .updateWithResponse(resourceGroupName, serviceName, identityProviderName, updateIfMatch, updateParameters,
                context)
            .getValue();
        return this;
    }

    IdentityProviderContractImpl(IdentityProviderContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.identityProviderName = IdentityProviderType
            .fromString(ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "identityProviders"));
    }

    public IdentityProviderContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getIdentityProviders()
            .getWithResponse(resourceGroupName, serviceName, identityProviderName, Context.NONE)
            .getValue();
        return this;
    }

    public IdentityProviderContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getIdentityProviders()
            .getWithResponse(resourceGroupName, serviceName, identityProviderName, context)
            .getValue();
        return this;
    }

    public Response<ClientSecretContract> listSecretsWithResponse(Context context) {
        return serviceManager.identityProviders()
            .listSecretsWithResponse(resourceGroupName, serviceName, identityProviderName, context);
    }

    public ClientSecretContract listSecrets() {
        return serviceManager.identityProviders().listSecrets(resourceGroupName, serviceName, identityProviderName);
    }

    public IdentityProviderContractImpl withClientId(String clientId) {
        if (isInCreateMode()) {
            this.createParameters.withClientId(clientId);
            return this;
        } else {
            this.updateParameters.withClientId(clientId);
            return this;
        }
    }

    public IdentityProviderContractImpl withClientSecret(String clientSecret) {
        if (isInCreateMode()) {
            this.createParameters.withClientSecret(clientSecret);
            return this;
        } else {
            this.updateParameters.withClientSecret(clientSecret);
            return this;
        }
    }

    public IdentityProviderContractImpl withTypePropertiesType(IdentityProviderType typePropertiesType) {
        this.createParameters.withTypePropertiesType(typePropertiesType);
        return this;
    }

    public IdentityProviderContractImpl withSigninTenant(String signinTenant) {
        if (isInCreateMode()) {
            this.createParameters.withSigninTenant(signinTenant);
            return this;
        } else {
            this.updateParameters.withSigninTenant(signinTenant);
            return this;
        }
    }

    public IdentityProviderContractImpl withAllowedTenants(List<String> allowedTenants) {
        if (isInCreateMode()) {
            this.createParameters.withAllowedTenants(allowedTenants);
            return this;
        } else {
            this.updateParameters.withAllowedTenants(allowedTenants);
            return this;
        }
    }

    public IdentityProviderContractImpl withAuthority(String authority) {
        if (isInCreateMode()) {
            this.createParameters.withAuthority(authority);
            return this;
        } else {
            this.updateParameters.withAuthority(authority);
            return this;
        }
    }

    public IdentityProviderContractImpl withSignupPolicyName(String signupPolicyName) {
        if (isInCreateMode()) {
            this.createParameters.withSignupPolicyName(signupPolicyName);
            return this;
        } else {
            this.updateParameters.withSignupPolicyName(signupPolicyName);
            return this;
        }
    }

    public IdentityProviderContractImpl withSigninPolicyName(String signinPolicyName) {
        if (isInCreateMode()) {
            this.createParameters.withSigninPolicyName(signinPolicyName);
            return this;
        } else {
            this.updateParameters.withSigninPolicyName(signinPolicyName);
            return this;
        }
    }

    public IdentityProviderContractImpl withProfileEditingPolicyName(String profileEditingPolicyName) {
        if (isInCreateMode()) {
            this.createParameters.withProfileEditingPolicyName(profileEditingPolicyName);
            return this;
        } else {
            this.updateParameters.withProfileEditingPolicyName(profileEditingPolicyName);
            return this;
        }
    }

    public IdentityProviderContractImpl withPasswordResetPolicyName(String passwordResetPolicyName) {
        if (isInCreateMode()) {
            this.createParameters.withPasswordResetPolicyName(passwordResetPolicyName);
            return this;
        } else {
            this.updateParameters.withPasswordResetPolicyName(passwordResetPolicyName);
            return this;
        }
    }

    public IdentityProviderContractImpl withClientLibrary(String clientLibrary) {
        if (isInCreateMode()) {
            this.createParameters.withClientLibrary(clientLibrary);
            return this;
        } else {
            this.updateParameters.withClientLibrary(clientLibrary);
            return this;
        }
    }

    public IdentityProviderContractImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    public IdentityProviderContractImpl withType(IdentityProviderType type) {
        this.updateParameters.withType(type);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
