// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.IdentityProvidersClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ClientSecretContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.IdentityProviderContractInner;
import com.azure.resourcemanager.apimanagement.models.ClientSecretContract;
import com.azure.resourcemanager.apimanagement.models.IdentityProviderContract;
import com.azure.resourcemanager.apimanagement.models.IdentityProviderType;
import com.azure.resourcemanager.apimanagement.models.IdentityProviders;
import com.azure.resourcemanager.apimanagement.models.IdentityProvidersGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.IdentityProvidersGetResponse;
import com.azure.resourcemanager.apimanagement.models.IdentityProvidersListSecretsResponse;

public final class IdentityProvidersImpl implements IdentityProviders {
    private static final ClientLogger LOGGER = new ClientLogger(IdentityProvidersImpl.class);

    private final IdentityProvidersClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public IdentityProvidersImpl(IdentityProvidersClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<IdentityProviderContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<IdentityProviderContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IdentityProviderContractImpl(inner1, this.manager()));
    }

    public PagedIterable<IdentityProviderContract> listByService(String resourceGroupName, String serviceName,
        Context context) {
        PagedIterable<IdentityProviderContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IdentityProviderContractImpl(inner1, this.manager()));
    }

    public IdentityProvidersGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        IdentityProviderType identityProviderName, Context context) {
        return this.serviceClient()
            .getEntityTagWithResponse(resourceGroupName, serviceName, identityProviderName, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, IdentityProviderType identityProviderName) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, identityProviderName);
    }

    public Response<IdentityProviderContract> getWithResponse(String resourceGroupName, String serviceName,
        IdentityProviderType identityProviderName, Context context) {
        IdentityProvidersGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, identityProviderName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new IdentityProviderContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public IdentityProviderContract get(String resourceGroupName, String serviceName,
        IdentityProviderType identityProviderName) {
        IdentityProviderContractInner inner
            = this.serviceClient().get(resourceGroupName, serviceName, identityProviderName);
        if (inner != null) {
            return new IdentityProviderContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName,
        IdentityProviderType identityProviderName, String ifMatch, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, serviceName, identityProviderName, ifMatch, context);
    }

    public void delete(String resourceGroupName, String serviceName, IdentityProviderType identityProviderName,
        String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, identityProviderName, ifMatch);
    }

    public Response<ClientSecretContract> listSecretsWithResponse(String resourceGroupName, String serviceName,
        IdentityProviderType identityProviderName, Context context) {
        IdentityProvidersListSecretsResponse inner = this.serviceClient()
            .listSecretsWithResponse(resourceGroupName, serviceName, identityProviderName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ClientSecretContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ClientSecretContract listSecrets(String resourceGroupName, String serviceName,
        IdentityProviderType identityProviderName) {
        ClientSecretContractInner inner
            = this.serviceClient().listSecrets(resourceGroupName, serviceName, identityProviderName);
        if (inner != null) {
            return new ClientSecretContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public IdentityProviderContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String identityProviderNameLocal = ResourceManagerUtils.getValueFromIdByName(id, "identityProviders");
        if (identityProviderNameLocal == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'identityProviders'.", id)));
        }
        IdentityProviderType identityProviderName = IdentityProviderType.fromString(identityProviderNameLocal);
        return this.getWithResponse(resourceGroupName, serviceName, identityProviderName, Context.NONE).getValue();
    }

    public Response<IdentityProviderContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String identityProviderNameLocal = ResourceManagerUtils.getValueFromIdByName(id, "identityProviders");
        if (identityProviderNameLocal == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'identityProviders'.", id)));
        }
        IdentityProviderType identityProviderName = IdentityProviderType.fromString(identityProviderNameLocal);
        return this.getWithResponse(resourceGroupName, serviceName, identityProviderName, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String identityProviderNameLocal = ResourceManagerUtils.getValueFromIdByName(id, "identityProviders");
        if (identityProviderNameLocal == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'identityProviders'.", id)));
        }
        IdentityProviderType identityProviderName = IdentityProviderType.fromString(identityProviderNameLocal);
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, identityProviderName, localIfMatch, Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String identityProviderNameLocal = ResourceManagerUtils.getValueFromIdByName(id, "identityProviders");
        if (identityProviderNameLocal == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'identityProviders'.", id)));
        }
        IdentityProviderType identityProviderName = IdentityProviderType.fromString(identityProviderNameLocal);
        return this.deleteWithResponse(resourceGroupName, serviceName, identityProviderName, ifMatch, context);
    }

    private IdentityProvidersClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    public IdentityProviderContractImpl define(IdentityProviderType name) {
        return new IdentityProviderContractImpl(name, this.manager());
    }
}
