// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.IssueCommentContractInner;
import com.azure.resourcemanager.apimanagement.models.IssueCommentContract;
import java.time.OffsetDateTime;

public final class IssueCommentContractImpl
    implements IssueCommentContract, IssueCommentContract.Definition, IssueCommentContract.Update {
    private IssueCommentContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String text() {
        return this.innerModel().text();
    }

    public OffsetDateTime createdDate() {
        return this.innerModel().createdDate();
    }

    public String userId() {
        return this.innerModel().userId();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public IssueCommentContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String apiId;

    private String issueId;

    private String commentId;

    private String createIfMatch;

    private String updateIfMatch;

    public IssueCommentContractImpl withExistingIssue(String resourceGroupName, String serviceName, String apiId,
        String issueId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.apiId = apiId;
        this.issueId = issueId;
        return this;
    }

    public IssueCommentContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getApiIssueComments()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, apiId, issueId, commentId, this.innerModel(),
                createIfMatch, Context.NONE)
            .getValue();
        return this;
    }

    public IssueCommentContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getApiIssueComments()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, apiId, issueId, commentId, this.innerModel(),
                createIfMatch, context)
            .getValue();
        return this;
    }

    IssueCommentContractImpl(String name, com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new IssueCommentContractInner();
        this.serviceManager = serviceManager;
        this.commentId = name;
        this.createIfMatch = null;
    }

    public IssueCommentContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    public IssueCommentContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getApiIssueComments()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, apiId, issueId, commentId, this.innerModel(),
                updateIfMatch, Context.NONE)
            .getValue();
        return this;
    }

    public IssueCommentContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getApiIssueComments()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, apiId, issueId, commentId, this.innerModel(),
                updateIfMatch, context)
            .getValue();
        return this;
    }

    IssueCommentContractImpl(IssueCommentContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.apiId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apis");
        this.issueId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "issues");
        this.commentId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "comments");
    }

    public IssueCommentContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getApiIssueComments()
            .getWithResponse(resourceGroupName, serviceName, apiId, issueId, commentId, Context.NONE)
            .getValue();
        return this;
    }

    public IssueCommentContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getApiIssueComments()
            .getWithResponse(resourceGroupName, serviceName, apiId, issueId, commentId, context)
            .getValue();
        return this;
    }

    public IssueCommentContractImpl withText(String text) {
        this.innerModel().withText(text);
        return this;
    }

    public IssueCommentContractImpl withCreatedDate(OffsetDateTime createdDate) {
        this.innerModel().withCreatedDate(createdDate);
        return this;
    }

    public IssueCommentContractImpl withUserId(String userId) {
        this.innerModel().withUserId(userId);
        return this;
    }

    public IssueCommentContractImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
