// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.IssuesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.IssueContractInner;
import com.azure.resourcemanager.apimanagement.models.IssueContract;
import com.azure.resourcemanager.apimanagement.models.Issues;
import com.azure.resourcemanager.apimanagement.models.IssuesGetResponse;

public final class IssuesImpl implements Issues {
    private static final ClientLogger LOGGER = new ClientLogger(IssuesImpl.class);

    private final IssuesClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public IssuesImpl(IssuesClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<IssueContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<IssueContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IssueContractImpl(inner1, this.manager()));
    }

    public PagedIterable<IssueContract> listByService(String resourceGroupName, String serviceName, String filter,
        Integer top, Integer skip, Context context) {
        PagedIterable<IssueContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IssueContractImpl(inner1, this.manager()));
    }

    public Response<IssueContract> getWithResponse(String resourceGroupName, String serviceName, String issueId,
        Context context) {
        IssuesGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, issueId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new IssueContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public IssueContract get(String resourceGroupName, String serviceName, String issueId) {
        IssueContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, issueId);
        if (inner != null) {
            return new IssueContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private IssuesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
