// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.NamedValuesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.NamedValueContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.NamedValueSecretContractInner;
import com.azure.resourcemanager.apimanagement.models.NamedValueContract;
import com.azure.resourcemanager.apimanagement.models.NamedValueSecretContract;
import com.azure.resourcemanager.apimanagement.models.NamedValues;
import com.azure.resourcemanager.apimanagement.models.NamedValuesGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.NamedValuesGetResponse;
import com.azure.resourcemanager.apimanagement.models.NamedValuesListValueResponse;

public final class NamedValuesImpl implements NamedValues {
    private static final ClientLogger LOGGER = new ClientLogger(NamedValuesImpl.class);

    private final NamedValuesClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public NamedValuesImpl(NamedValuesClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<NamedValueContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<NamedValueContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NamedValueContractImpl(inner1, this.manager()));
    }

    public PagedIterable<NamedValueContract> listByService(String resourceGroupName, String serviceName, String filter,
        Integer top, Integer skip, Boolean isKeyVaultRefreshFailed, Context context) {
        PagedIterable<NamedValueContractInner> inner = this.serviceClient()
            .listByService(resourceGroupName, serviceName, filter, top, skip, isKeyVaultRefreshFailed, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NamedValueContractImpl(inner1, this.manager()));
    }

    public NamedValuesGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        String namedValueId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, namedValueId, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String namedValueId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, namedValueId);
    }

    public Response<NamedValueContract> getWithResponse(String resourceGroupName, String serviceName,
        String namedValueId, Context context) {
        NamedValuesGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, namedValueId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new NamedValueContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public NamedValueContract get(String resourceGroupName, String serviceName, String namedValueId) {
        NamedValueContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, namedValueId);
        if (inner != null) {
            return new NamedValueContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String namedValueId,
        String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, namedValueId, ifMatch, context);
    }

    public void delete(String resourceGroupName, String serviceName, String namedValueId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, namedValueId, ifMatch);
    }

    public Response<NamedValueSecretContract> listValueWithResponse(String resourceGroupName, String serviceName,
        String namedValueId, Context context) {
        NamedValuesListValueResponse inner
            = this.serviceClient().listValueWithResponse(resourceGroupName, serviceName, namedValueId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new NamedValueSecretContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public NamedValueSecretContract listValue(String resourceGroupName, String serviceName, String namedValueId) {
        NamedValueSecretContractInner inner
            = this.serviceClient().listValue(resourceGroupName, serviceName, namedValueId);
        if (inner != null) {
            return new NamedValueSecretContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public NamedValueContract refreshSecret(String resourceGroupName, String serviceName, String namedValueId) {
        NamedValueContractInner inner
            = this.serviceClient().refreshSecret(resourceGroupName, serviceName, namedValueId);
        if (inner != null) {
            return new NamedValueContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public NamedValueContract refreshSecret(String resourceGroupName, String serviceName, String namedValueId,
        Context context) {
        NamedValueContractInner inner
            = this.serviceClient().refreshSecret(resourceGroupName, serviceName, namedValueId, context);
        if (inner != null) {
            return new NamedValueContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public NamedValueContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String namedValueId = ResourceManagerUtils.getValueFromIdByName(id, "namedValues");
        if (namedValueId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'namedValues'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, namedValueId, Context.NONE).getValue();
    }

    public Response<NamedValueContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String namedValueId = ResourceManagerUtils.getValueFromIdByName(id, "namedValues");
        if (namedValueId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'namedValues'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, namedValueId, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String namedValueId = ResourceManagerUtils.getValueFromIdByName(id, "namedValues");
        if (namedValueId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'namedValues'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, namedValueId, localIfMatch, Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String namedValueId = ResourceManagerUtils.getValueFromIdByName(id, "namedValues");
        if (namedValueId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'namedValues'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, namedValueId, ifMatch, context);
    }

    private NamedValuesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    public NamedValueContractImpl define(String name) {
        return new NamedValueContractImpl(name, this.manager());
    }
}
