// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.resourcemanager.apimanagement.fluent.models.NetworkStatusContractInner;
import com.azure.resourcemanager.apimanagement.models.ConnectivityStatusContract;
import com.azure.resourcemanager.apimanagement.models.NetworkStatusContract;
import java.util.Collections;
import java.util.List;

public final class NetworkStatusContractImpl implements NetworkStatusContract {
    private NetworkStatusContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    NetworkStatusContractImpl(NetworkStatusContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    public List<String> dnsServers() {
        List<String> inner = this.innerModel().dnsServers();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public List<ConnectivityStatusContract> connectivityStatus() {
        List<ConnectivityStatusContract> inner = this.innerModel().connectivityStatus();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public NetworkStatusContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
