// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.OpenidConnectProviderContractInner;
import com.azure.resourcemanager.apimanagement.models.ClientSecretContract;
import com.azure.resourcemanager.apimanagement.models.OpenidConnectProviderContract;
import com.azure.resourcemanager.apimanagement.models.OpenidConnectProviderUpdateContract;

public final class OpenidConnectProviderContractImpl implements OpenidConnectProviderContract,
    OpenidConnectProviderContract.Definition, OpenidConnectProviderContract.Update {
    private OpenidConnectProviderContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String displayName() {
        return this.innerModel().displayName();
    }

    public String description() {
        return this.innerModel().description();
    }

    public String metadataEndpoint() {
        return this.innerModel().metadataEndpoint();
    }

    public String clientId() {
        return this.innerModel().clientId();
    }

    public String clientSecret() {
        return this.innerModel().clientSecret();
    }

    public Boolean useInTestConsole() {
        return this.innerModel().useInTestConsole();
    }

    public Boolean useInApiDocumentation() {
        return this.innerModel().useInApiDocumentation();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public OpenidConnectProviderContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String opid;

    private String createIfMatch;

    private String updateIfMatch;

    private OpenidConnectProviderUpdateContract updateParameters;

    public OpenidConnectProviderContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    public OpenidConnectProviderContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getOpenIdConnectProviders()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, opid, this.innerModel(), createIfMatch,
                Context.NONE)
            .getValue();
        return this;
    }

    public OpenidConnectProviderContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getOpenIdConnectProviders()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, opid, this.innerModel(), createIfMatch, context)
            .getValue();
        return this;
    }

    OpenidConnectProviderContractImpl(String name,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new OpenidConnectProviderContractInner();
        this.serviceManager = serviceManager;
        this.opid = name;
        this.createIfMatch = null;
    }

    public OpenidConnectProviderContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new OpenidConnectProviderUpdateContract();
        return this;
    }

    public OpenidConnectProviderContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getOpenIdConnectProviders()
            .updateWithResponse(resourceGroupName, serviceName, opid, updateIfMatch, updateParameters, Context.NONE)
            .getValue();
        return this;
    }

    public OpenidConnectProviderContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getOpenIdConnectProviders()
            .updateWithResponse(resourceGroupName, serviceName, opid, updateIfMatch, updateParameters, context)
            .getValue();
        return this;
    }

    OpenidConnectProviderContractImpl(OpenidConnectProviderContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.opid = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "openidConnectProviders");
    }

    public OpenidConnectProviderContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getOpenIdConnectProviders()
            .getWithResponse(resourceGroupName, serviceName, opid, Context.NONE)
            .getValue();
        return this;
    }

    public OpenidConnectProviderContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getOpenIdConnectProviders()
            .getWithResponse(resourceGroupName, serviceName, opid, context)
            .getValue();
        return this;
    }

    public Response<ClientSecretContract> listSecretsWithResponse(Context context) {
        return serviceManager.openIdConnectProviders()
            .listSecretsWithResponse(resourceGroupName, serviceName, opid, context);
    }

    public ClientSecretContract listSecrets() {
        return serviceManager.openIdConnectProviders().listSecrets(resourceGroupName, serviceName, opid);
    }

    public OpenidConnectProviderContractImpl withDisplayName(String displayName) {
        if (isInCreateMode()) {
            this.innerModel().withDisplayName(displayName);
            return this;
        } else {
            this.updateParameters.withDisplayName(displayName);
            return this;
        }
    }

    public OpenidConnectProviderContractImpl withDescription(String description) {
        if (isInCreateMode()) {
            this.innerModel().withDescription(description);
            return this;
        } else {
            this.updateParameters.withDescription(description);
            return this;
        }
    }

    public OpenidConnectProviderContractImpl withMetadataEndpoint(String metadataEndpoint) {
        if (isInCreateMode()) {
            this.innerModel().withMetadataEndpoint(metadataEndpoint);
            return this;
        } else {
            this.updateParameters.withMetadataEndpoint(metadataEndpoint);
            return this;
        }
    }

    public OpenidConnectProviderContractImpl withClientId(String clientId) {
        if (isInCreateMode()) {
            this.innerModel().withClientId(clientId);
            return this;
        } else {
            this.updateParameters.withClientId(clientId);
            return this;
        }
    }

    public OpenidConnectProviderContractImpl withClientSecret(String clientSecret) {
        if (isInCreateMode()) {
            this.innerModel().withClientSecret(clientSecret);
            return this;
        } else {
            this.updateParameters.withClientSecret(clientSecret);
            return this;
        }
    }

    public OpenidConnectProviderContractImpl withUseInTestConsole(Boolean useInTestConsole) {
        if (isInCreateMode()) {
            this.innerModel().withUseInTestConsole(useInTestConsole);
            return this;
        } else {
            this.updateParameters.withUseInTestConsole(useInTestConsole);
            return this;
        }
    }

    public OpenidConnectProviderContractImpl withUseInApiDocumentation(Boolean useInApiDocumentation) {
        if (isInCreateMode()) {
            this.innerModel().withUseInApiDocumentation(useInApiDocumentation);
            return this;
        } else {
            this.updateParameters.withUseInApiDocumentation(useInApiDocumentation);
            return this;
        }
    }

    public OpenidConnectProviderContractImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
