// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.OperationContractInner;
import com.azure.resourcemanager.apimanagement.models.OperationContract;
import com.azure.resourcemanager.apimanagement.models.OperationUpdateContract;
import com.azure.resourcemanager.apimanagement.models.ParameterContract;
import com.azure.resourcemanager.apimanagement.models.RequestContract;
import com.azure.resourcemanager.apimanagement.models.ResponseContract;
import java.util.Collections;
import java.util.List;

public final class OperationContractImpl
    implements OperationContract, OperationContract.Definition, OperationContract.Update {
    private OperationContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String displayName() {
        return this.innerModel().displayName();
    }

    public String method() {
        return this.innerModel().method();
    }

    public String urlTemplate() {
        return this.innerModel().urlTemplate();
    }

    public List<ParameterContract> templateParameters() {
        List<ParameterContract> inner = this.innerModel().templateParameters();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public String description() {
        return this.innerModel().description();
    }

    public RequestContract request() {
        return this.innerModel().request();
    }

    public List<ResponseContract> responses() {
        List<ResponseContract> inner = this.innerModel().responses();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public String policies() {
        return this.innerModel().policies();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public OperationContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String apiId;

    private String operationId;

    private String createIfMatch;

    private String updateIfMatch;

    private OperationUpdateContract updateParameters;

    public OperationContractImpl withExistingApi(String resourceGroupName, String serviceName, String apiId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.apiId = apiId;
        return this;
    }

    public OperationContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getApiOperations()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, apiId, operationId, this.innerModel(),
                createIfMatch, Context.NONE)
            .getValue();
        return this;
    }

    public OperationContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getApiOperations()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, apiId, operationId, this.innerModel(),
                createIfMatch, context)
            .getValue();
        return this;
    }

    OperationContractImpl(String name, com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new OperationContractInner();
        this.serviceManager = serviceManager;
        this.operationId = name;
        this.createIfMatch = null;
    }

    public OperationContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new OperationUpdateContract();
        return this;
    }

    public OperationContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getApiOperations()
            .updateWithResponse(resourceGroupName, serviceName, apiId, operationId, updateIfMatch, updateParameters,
                Context.NONE)
            .getValue();
        return this;
    }

    public OperationContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getApiOperations()
            .updateWithResponse(resourceGroupName, serviceName, apiId, operationId, updateIfMatch, updateParameters,
                context)
            .getValue();
        return this;
    }

    OperationContractImpl(OperationContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.apiId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apis");
        this.operationId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "operations");
    }

    public OperationContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getApiOperations()
            .getWithResponse(resourceGroupName, serviceName, apiId, operationId, Context.NONE)
            .getValue();
        return this;
    }

    public OperationContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getApiOperations()
            .getWithResponse(resourceGroupName, serviceName, apiId, operationId, context)
            .getValue();
        return this;
    }

    public OperationContractImpl withDisplayName(String displayName) {
        if (isInCreateMode()) {
            this.innerModel().withDisplayName(displayName);
            return this;
        } else {
            this.updateParameters.withDisplayName(displayName);
            return this;
        }
    }

    public OperationContractImpl withMethod(String method) {
        if (isInCreateMode()) {
            this.innerModel().withMethod(method);
            return this;
        } else {
            this.updateParameters.withMethod(method);
            return this;
        }
    }

    public OperationContractImpl withUrlTemplate(String urlTemplate) {
        if (isInCreateMode()) {
            this.innerModel().withUrlTemplate(urlTemplate);
            return this;
        } else {
            this.updateParameters.withUrlTemplate(urlTemplate);
            return this;
        }
    }

    public OperationContractImpl withTemplateParameters(List<ParameterContract> templateParameters) {
        if (isInCreateMode()) {
            this.innerModel().withTemplateParameters(templateParameters);
            return this;
        } else {
            this.updateParameters.withTemplateParameters(templateParameters);
            return this;
        }
    }

    public OperationContractImpl withDescription(String description) {
        if (isInCreateMode()) {
            this.innerModel().withDescription(description);
            return this;
        } else {
            this.updateParameters.withDescription(description);
            return this;
        }
    }

    public OperationContractImpl withRequest(RequestContract request) {
        if (isInCreateMode()) {
            this.innerModel().withRequest(request);
            return this;
        } else {
            this.updateParameters.withRequest(request);
            return this;
        }
    }

    public OperationContractImpl withResponses(List<ResponseContract> responses) {
        if (isInCreateMode()) {
            this.innerModel().withResponses(responses);
            return this;
        } else {
            this.updateParameters.withResponses(responses);
            return this;
        }
    }

    public OperationContractImpl withPolicies(String policies) {
        if (isInCreateMode()) {
            this.innerModel().withPolicies(policies);
            return this;
        } else {
            this.updateParameters.withPolicies(policies);
            return this;
        }
    }

    public OperationContractImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
