// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.resourcemanager.apimanagement.fluent.models.OperationResultContractInner;
import com.azure.resourcemanager.apimanagement.models.AsyncOperationStatus;
import com.azure.resourcemanager.apimanagement.models.ErrorResponseBody;
import com.azure.resourcemanager.apimanagement.models.OperationResultContract;
import com.azure.resourcemanager.apimanagement.models.OperationResultLogItemContract;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;

public final class OperationResultContractImpl implements OperationResultContract {
    private OperationResultContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    OperationResultContractImpl(OperationResultContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String idPropertiesId() {
        return this.innerModel().idPropertiesId();
    }

    public AsyncOperationStatus status() {
        return this.innerModel().status();
    }

    public OffsetDateTime started() {
        return this.innerModel().started();
    }

    public OffsetDateTime updated() {
        return this.innerModel().updated();
    }

    public String resultInfo() {
        return this.innerModel().resultInfo();
    }

    public ErrorResponseBody error() {
        return this.innerModel().error();
    }

    public List<OperationResultLogItemContract> actionLog() {
        List<OperationResultLogItemContract> inner = this.innerModel().actionLog();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public OperationResultContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
