// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.OperationStatusClient;
import com.azure.resourcemanager.apimanagement.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.apimanagement.models.OperationStatus;
import com.azure.resourcemanager.apimanagement.models.OperationStatusResult;

public final class OperationStatusImpl implements OperationStatus {
    private static final ClientLogger LOGGER = new ClientLogger(OperationStatusImpl.class);

    private final OperationStatusClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public OperationStatusImpl(OperationStatusClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<OperationStatusResult> getWithResponse(String location, String operationId, Context context) {
        Response<OperationStatusResultInner> inner
            = this.serviceClient().getWithResponse(location, operationId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new OperationStatusResultImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public OperationStatusResult get(String location, String operationId) {
        OperationStatusResultInner inner = this.serviceClient().get(location, operationId);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private OperationStatusClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
