// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.OperationsResultsClient;
import com.azure.resourcemanager.apimanagement.models.OperationsResults;
import com.azure.resourcemanager.apimanagement.models.OperationsResultsGetResponse;

public final class OperationsResultsImpl implements OperationsResults {
    private static final ClientLogger LOGGER = new ClientLogger(OperationsResultsImpl.class);

    private final OperationsResultsClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public OperationsResultsImpl(OperationsResultsClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public OperationsResultsGetResponse getWithResponse(String location, String operationId, Context context) {
        return this.serviceClient().getWithResponse(location, operationId, context);
    }

    public void get(String location, String operationId) {
        this.serviceClient().get(location, operationId);
    }

    private OperationsResultsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
