// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.OutboundNetworkDependenciesEndpointsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.OutboundEnvironmentEndpointListInner;
import com.azure.resourcemanager.apimanagement.models.OutboundEnvironmentEndpointList;
import com.azure.resourcemanager.apimanagement.models.OutboundNetworkDependenciesEndpoints;

public final class OutboundNetworkDependenciesEndpointsImpl implements OutboundNetworkDependenciesEndpoints {
    private static final ClientLogger LOGGER = new ClientLogger(OutboundNetworkDependenciesEndpointsImpl.class);

    private final OutboundNetworkDependenciesEndpointsClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public OutboundNetworkDependenciesEndpointsImpl(OutboundNetworkDependenciesEndpointsClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<OutboundEnvironmentEndpointList> listByServiceWithResponse(String resourceGroupName,
        String serviceName, Context context) {
        Response<OutboundEnvironmentEndpointListInner> inner
            = this.serviceClient().listByServiceWithResponse(resourceGroupName, serviceName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new OutboundEnvironmentEndpointListImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public OutboundEnvironmentEndpointList listByService(String resourceGroupName, String serviceName) {
        OutboundEnvironmentEndpointListInner inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        if (inner != null) {
            return new OutboundEnvironmentEndpointListImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private OutboundNetworkDependenciesEndpointsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
