// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyContractInner;
import com.azure.resourcemanager.apimanagement.models.PolicyContentFormat;
import com.azure.resourcemanager.apimanagement.models.PolicyContract;
import com.azure.resourcemanager.apimanagement.models.PolicyExportFormat;
import com.azure.resourcemanager.apimanagement.models.PolicyIdName;

public final class PolicyContractImpl implements PolicyContract, PolicyContract.Definition, PolicyContract.Update {
    private PolicyContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String value() {
        return this.innerModel().value();
    }

    public PolicyContentFormat format() {
        return this.innerModel().format();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public PolicyContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String apiId;

    private String operationId;

    private PolicyIdName policyId;

    private String createIfMatch;

    private String updateIfMatch;

    public PolicyContractImpl withExistingOperation(String resourceGroupName, String serviceName, String apiId,
        String operationId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.apiId = apiId;
        this.operationId = operationId;
        return this;
    }

    public PolicyContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getApiOperationPolicies()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, apiId, operationId, policyId, this.innerModel(),
                createIfMatch, Context.NONE)
            .getValue();
        return this;
    }

    public PolicyContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getApiOperationPolicies()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, apiId, operationId, policyId, this.innerModel(),
                createIfMatch, context)
            .getValue();
        return this;
    }

    PolicyContractImpl(PolicyIdName name, com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new PolicyContractInner();
        this.serviceManager = serviceManager;
        this.policyId = name;
        this.createIfMatch = null;
    }

    public PolicyContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    public PolicyContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getApiOperationPolicies()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, apiId, operationId, policyId, this.innerModel(),
                updateIfMatch, Context.NONE)
            .getValue();
        return this;
    }

    public PolicyContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getApiOperationPolicies()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, apiId, operationId, policyId, this.innerModel(),
                updateIfMatch, context)
            .getValue();
        return this;
    }

    PolicyContractImpl(PolicyContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.apiId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apis");
        this.operationId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "operations");
        this.policyId
            = PolicyIdName.fromString(ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "policies"));
    }

    public PolicyContract refresh() {
        PolicyExportFormat localFormat = null;
        this.innerObject = serviceManager.serviceClient()
            .getApiOperationPolicies()
            .getWithResponse(resourceGroupName, serviceName, apiId, operationId, policyId, localFormat, Context.NONE)
            .getValue();
        return this;
    }

    public PolicyContract refresh(Context context) {
        PolicyExportFormat localFormat = null;
        this.innerObject = serviceManager.serviceClient()
            .getApiOperationPolicies()
            .getWithResponse(resourceGroupName, serviceName, apiId, operationId, policyId, localFormat, context)
            .getValue();
        return this;
    }

    public PolicyContractImpl withValue(String value) {
        this.innerModel().withValue(value);
        return this;
    }

    public PolicyContractImpl withFormat(PolicyContentFormat format) {
        this.innerModel().withFormat(format);
        return this;
    }

    public PolicyContractImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
