// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyFragmentContractInner;
import com.azure.resourcemanager.apimanagement.models.PolicyFragmentContentFormat;
import com.azure.resourcemanager.apimanagement.models.PolicyFragmentContract;
import com.azure.resourcemanager.apimanagement.models.ResourceCollection;

public final class PolicyFragmentContractImpl
    implements PolicyFragmentContract, PolicyFragmentContract.Definition, PolicyFragmentContract.Update {
    private PolicyFragmentContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String value() {
        return this.innerModel().value();
    }

    public String description() {
        return this.innerModel().description();
    }

    public PolicyFragmentContentFormat format() {
        return this.innerModel().format();
    }

    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public PolicyFragmentContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String id;

    private String createIfMatch;

    private String updateIfMatch;

    public PolicyFragmentContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    public PolicyFragmentContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getPolicyFragments()
            .createOrUpdate(resourceGroupName, serviceName, id, this.innerModel(), createIfMatch, Context.NONE);
        return this;
    }

    public PolicyFragmentContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getPolicyFragments()
            .createOrUpdate(resourceGroupName, serviceName, id, this.innerModel(), createIfMatch, context);
        return this;
    }

    PolicyFragmentContractImpl(String name,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new PolicyFragmentContractInner();
        this.serviceManager = serviceManager;
        this.id = name;
        this.createIfMatch = null;
    }

    public PolicyFragmentContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    public PolicyFragmentContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getPolicyFragments()
            .createOrUpdate(resourceGroupName, serviceName, id, this.innerModel(), updateIfMatch, Context.NONE);
        return this;
    }

    public PolicyFragmentContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getPolicyFragments()
            .createOrUpdate(resourceGroupName, serviceName, id, this.innerModel(), updateIfMatch, context);
        return this;
    }

    PolicyFragmentContractImpl(PolicyFragmentContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.id = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "policyFragments");
    }

    public PolicyFragmentContract refresh() {
        PolicyFragmentContentFormat localFormat = null;
        this.innerObject = serviceManager.serviceClient()
            .getPolicyFragments()
            .getWithResponse(resourceGroupName, serviceName, id, localFormat, Context.NONE)
            .getValue();
        return this;
    }

    public PolicyFragmentContract refresh(Context context) {
        PolicyFragmentContentFormat localFormat = null;
        this.innerObject = serviceManager.serviceClient()
            .getPolicyFragments()
            .getWithResponse(resourceGroupName, serviceName, id, localFormat, context)
            .getValue();
        return this;
    }

    public Response<ResourceCollection> listReferencesWithResponse(Integer top, Integer skip, Context context) {
        return serviceManager.policyFragments()
            .listReferencesWithResponse(resourceGroupName, serviceName, id, top, skip, context);
    }

    public ResourceCollection listReferences() {
        return serviceManager.policyFragments().listReferences(resourceGroupName, serviceName, id);
    }

    public PolicyFragmentContractImpl withValue(String value) {
        this.innerModel().withValue(value);
        return this;
    }

    public PolicyFragmentContractImpl withDescription(String description) {
        this.innerModel().withDescription(description);
        return this;
    }

    public PolicyFragmentContractImpl withFormat(PolicyFragmentContentFormat format) {
        this.innerModel().withFormat(format);
        return this;
    }

    public PolicyFragmentContractImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
