// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.PolicyFragmentsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyFragmentContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.ResourceCollectionInner;
import com.azure.resourcemanager.apimanagement.models.PolicyFragmentContentFormat;
import com.azure.resourcemanager.apimanagement.models.PolicyFragmentContract;
import com.azure.resourcemanager.apimanagement.models.PolicyFragments;
import com.azure.resourcemanager.apimanagement.models.PolicyFragmentsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.PolicyFragmentsGetResponse;
import com.azure.resourcemanager.apimanagement.models.ResourceCollection;

public final class PolicyFragmentsImpl implements PolicyFragments {
    private static final ClientLogger LOGGER = new ClientLogger(PolicyFragmentsImpl.class);

    private final PolicyFragmentsClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public PolicyFragmentsImpl(PolicyFragmentsClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<PolicyFragmentContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<PolicyFragmentContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyFragmentContractImpl(inner1, this.manager()));
    }

    public PagedIterable<PolicyFragmentContract> listByService(String resourceGroupName, String serviceName,
        String filter, String orderby, Integer top, Integer skip, Context context) {
        PagedIterable<PolicyFragmentContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName, filter, orderby, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyFragmentContractImpl(inner1, this.manager()));
    }

    public PolicyFragmentsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        String id, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, id, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String id) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, id);
    }

    public Response<PolicyFragmentContract> getWithResponse(String resourceGroupName, String serviceName, String id,
        PolicyFragmentContentFormat format, Context context) {
        PolicyFragmentsGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, id, format, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new PolicyFragmentContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public PolicyFragmentContract get(String resourceGroupName, String serviceName, String id) {
        PolicyFragmentContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, id);
        if (inner != null) {
            return new PolicyFragmentContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String id, String ifMatch,
        Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, id, ifMatch, context);
    }

    public void delete(String resourceGroupName, String serviceName, String id, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, id, ifMatch);
    }

    public Response<ResourceCollection> listReferencesWithResponse(String resourceGroupName, String serviceName,
        String id, Integer top, Integer skip, Context context) {
        Response<ResourceCollectionInner> inner
            = this.serviceClient().listReferencesWithResponse(resourceGroupName, serviceName, id, top, skip, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ResourceCollectionImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ResourceCollection listReferences(String resourceGroupName, String serviceName, String id) {
        ResourceCollectionInner inner = this.serviceClient().listReferences(resourceGroupName, serviceName, id);
        if (inner != null) {
            return new ResourceCollectionImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public PolicyFragmentContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String varId = ResourceManagerUtils.getValueFromIdByName(id, "policyFragments");
        if (varId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'policyFragments'.", id)));
        }
        PolicyFragmentContentFormat localFormat = null;
        return this.getWithResponse(resourceGroupName, serviceName, varId, localFormat, Context.NONE).getValue();
    }

    public Response<PolicyFragmentContract> getByIdWithResponse(String id, PolicyFragmentContentFormat format,
        Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String varId = ResourceManagerUtils.getValueFromIdByName(id, "policyFragments");
        if (varId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'policyFragments'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, varId, format, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String varId = ResourceManagerUtils.getValueFromIdByName(id, "policyFragments");
        if (varId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'policyFragments'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, varId, localIfMatch, Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String varId = ResourceManagerUtils.getValueFromIdByName(id, "policyFragments");
        if (varId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'policyFragments'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, varId, ifMatch, context);
    }

    private PolicyFragmentsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    public PolicyFragmentContractImpl define(String name) {
        return new PolicyFragmentContractImpl(name, this.manager());
    }
}
