// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyRestrictionContractInner;
import com.azure.resourcemanager.apimanagement.models.PolicyRestrictionContract;
import com.azure.resourcemanager.apimanagement.models.PolicyRestrictionRequireBase;
import com.azure.resourcemanager.apimanagement.models.PolicyRestrictionUpdateContract;

public final class PolicyRestrictionContractImpl
    implements PolicyRestrictionContract, PolicyRestrictionContract.Definition, PolicyRestrictionContract.Update {
    private PolicyRestrictionContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String scope() {
        return this.innerModel().scope();
    }

    public PolicyRestrictionRequireBase requireBase() {
        return this.innerModel().requireBase();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public PolicyRestrictionContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String policyRestrictionId;

    private String createIfMatch;

    private String updateIfMatch;

    private PolicyRestrictionUpdateContract updateParameters;

    public PolicyRestrictionContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    public PolicyRestrictionContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getPolicyRestrictions()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, policyRestrictionId, this.innerModel(),
                createIfMatch, Context.NONE)
            .getValue();
        return this;
    }

    public PolicyRestrictionContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getPolicyRestrictions()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, policyRestrictionId, this.innerModel(),
                createIfMatch, context)
            .getValue();
        return this;
    }

    PolicyRestrictionContractImpl(String name,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new PolicyRestrictionContractInner();
        this.serviceManager = serviceManager;
        this.policyRestrictionId = name;
        this.createIfMatch = null;
    }

    public PolicyRestrictionContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new PolicyRestrictionUpdateContract();
        return this;
    }

    public PolicyRestrictionContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getPolicyRestrictions()
            .updateWithResponse(resourceGroupName, serviceName, policyRestrictionId, updateIfMatch, updateParameters,
                Context.NONE)
            .getValue();
        return this;
    }

    public PolicyRestrictionContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getPolicyRestrictions()
            .updateWithResponse(resourceGroupName, serviceName, policyRestrictionId, updateIfMatch, updateParameters,
                context)
            .getValue();
        return this;
    }

    PolicyRestrictionContractImpl(PolicyRestrictionContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.policyRestrictionId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "policyRestrictions");
    }

    public PolicyRestrictionContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getPolicyRestrictions()
            .getWithResponse(resourceGroupName, serviceName, policyRestrictionId, Context.NONE)
            .getValue();
        return this;
    }

    public PolicyRestrictionContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getPolicyRestrictions()
            .getWithResponse(resourceGroupName, serviceName, policyRestrictionId, context)
            .getValue();
        return this;
    }

    public PolicyRestrictionContractImpl withScope(String scope) {
        if (isInCreateMode()) {
            this.innerModel().withScope(scope);
            return this;
        } else {
            this.updateParameters.withScope(scope);
            return this;
        }
    }

    public PolicyRestrictionContractImpl withRequireBase(PolicyRestrictionRequireBase requireBase) {
        if (isInCreateMode()) {
            this.innerModel().withRequireBase(requireBase);
            return this;
        } else {
            this.updateParameters.withRequireBase(requireBase);
            return this;
        }
    }

    public PolicyRestrictionContractImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
