// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.PolicyRestrictionValidationsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.OperationResultContractInner;
import com.azure.resourcemanager.apimanagement.models.OperationResultContract;
import com.azure.resourcemanager.apimanagement.models.PolicyRestrictionValidations;

public final class PolicyRestrictionValidationsImpl implements PolicyRestrictionValidations {
    private static final ClientLogger LOGGER = new ClientLogger(PolicyRestrictionValidationsImpl.class);

    private final PolicyRestrictionValidationsClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public PolicyRestrictionValidationsImpl(PolicyRestrictionValidationsClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public OperationResultContract byService(String resourceGroupName, String serviceName) {
        OperationResultContractInner inner = this.serviceClient().byService(resourceGroupName, serviceName);
        if (inner != null) {
            return new OperationResultContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public OperationResultContract byService(String resourceGroupName, String serviceName, Context context) {
        OperationResultContractInner inner = this.serviceClient().byService(resourceGroupName, serviceName, context);
        if (inner != null) {
            return new OperationResultContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private PolicyRestrictionValidationsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
