// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.PortalRevisionContractInner;
import com.azure.resourcemanager.apimanagement.models.PortalRevisionContract;
import com.azure.resourcemanager.apimanagement.models.PortalRevisionStatus;
import java.time.OffsetDateTime;

public final class PortalRevisionContractImpl
    implements PortalRevisionContract, PortalRevisionContract.Definition, PortalRevisionContract.Update {
    private PortalRevisionContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String description() {
        return this.innerModel().description();
    }

    public String statusDetails() {
        return this.innerModel().statusDetails();
    }

    public PortalRevisionStatus status() {
        return this.innerModel().status();
    }

    public Boolean isCurrent() {
        return this.innerModel().isCurrent();
    }

    public OffsetDateTime createdDateTime() {
        return this.innerModel().createdDateTime();
    }

    public OffsetDateTime updatedDateTime() {
        return this.innerModel().updatedDateTime();
    }

    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public PortalRevisionContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String portalRevisionId;

    private String updateIfMatch;

    public PortalRevisionContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    public PortalRevisionContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getPortalRevisions()
            .createOrUpdate(resourceGroupName, serviceName, portalRevisionId, this.innerModel(), Context.NONE);
        return this;
    }

    public PortalRevisionContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getPortalRevisions()
            .createOrUpdate(resourceGroupName, serviceName, portalRevisionId, this.innerModel(), context);
        return this;
    }

    PortalRevisionContractImpl(String name,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new PortalRevisionContractInner();
        this.serviceManager = serviceManager;
        this.portalRevisionId = name;
    }

    public PortalRevisionContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    public PortalRevisionContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getPortalRevisions()
            .update(resourceGroupName, serviceName, portalRevisionId, updateIfMatch, this.innerModel(), Context.NONE);
        return this;
    }

    public PortalRevisionContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getPortalRevisions()
            .update(resourceGroupName, serviceName, portalRevisionId, updateIfMatch, this.innerModel(), context);
        return this;
    }

    PortalRevisionContractImpl(PortalRevisionContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.portalRevisionId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "portalRevisions");
    }

    public PortalRevisionContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getPortalRevisions()
            .getWithResponse(resourceGroupName, serviceName, portalRevisionId, Context.NONE)
            .getValue();
        return this;
    }

    public PortalRevisionContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getPortalRevisions()
            .getWithResponse(resourceGroupName, serviceName, portalRevisionId, context)
            .getValue();
        return this;
    }

    public PortalRevisionContractImpl withDescription(String description) {
        this.innerModel().withDescription(description);
        return this;
    }

    public PortalRevisionContractImpl withIsCurrent(Boolean isCurrent) {
        this.innerModel().withIsCurrent(isCurrent);
        return this;
    }

    public PortalRevisionContractImpl withIfMatch(String ifMatch) {
        this.updateIfMatch = ifMatch;
        return this;
    }
}
