// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.PortalRevisionsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.PortalRevisionContractInner;
import com.azure.resourcemanager.apimanagement.models.PortalRevisionContract;
import com.azure.resourcemanager.apimanagement.models.PortalRevisions;
import com.azure.resourcemanager.apimanagement.models.PortalRevisionsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.PortalRevisionsGetResponse;

public final class PortalRevisionsImpl implements PortalRevisions {
    private static final ClientLogger LOGGER = new ClientLogger(PortalRevisionsImpl.class);

    private final PortalRevisionsClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public PortalRevisionsImpl(PortalRevisionsClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<PortalRevisionContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<PortalRevisionContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PortalRevisionContractImpl(inner1, this.manager()));
    }

    public PagedIterable<PortalRevisionContract> listByService(String resourceGroupName, String serviceName,
        String filter, Integer top, Integer skip, Context context) {
        PagedIterable<PortalRevisionContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PortalRevisionContractImpl(inner1, this.manager()));
    }

    public PortalRevisionsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        String portalRevisionId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, portalRevisionId, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String portalRevisionId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, portalRevisionId);
    }

    public Response<PortalRevisionContract> getWithResponse(String resourceGroupName, String serviceName,
        String portalRevisionId, Context context) {
        PortalRevisionsGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, portalRevisionId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new PortalRevisionContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public PortalRevisionContract get(String resourceGroupName, String serviceName, String portalRevisionId) {
        PortalRevisionContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, portalRevisionId);
        if (inner != null) {
            return new PortalRevisionContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public PortalRevisionContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String portalRevisionId = ResourceManagerUtils.getValueFromIdByName(id, "portalRevisions");
        if (portalRevisionId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'portalRevisions'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, portalRevisionId, Context.NONE).getValue();
    }

    public Response<PortalRevisionContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String portalRevisionId = ResourceManagerUtils.getValueFromIdByName(id, "portalRevisions");
        if (portalRevisionId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'portalRevisions'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, portalRevisionId, context);
    }

    private PortalRevisionsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    public PortalRevisionContractImpl define(String name) {
        return new PortalRevisionContractImpl(name, this.manager());
    }
}
