// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.apimanagement.models.PrivateEndpoint;
import com.azure.resourcemanager.apimanagement.models.PrivateEndpointConnection;
import com.azure.resourcemanager.apimanagement.models.PrivateEndpointConnectionProvisioningState;
import com.azure.resourcemanager.apimanagement.models.PrivateEndpointConnectionRequest;
import com.azure.resourcemanager.apimanagement.models.PrivateEndpointConnectionRequestProperties;
import com.azure.resourcemanager.apimanagement.models.PrivateLinkServiceConnectionState;

public final class PrivateEndpointConnectionImpl
    implements PrivateEndpointConnection, PrivateEndpointConnection.Definition, PrivateEndpointConnection.Update {
    private PrivateEndpointConnectionInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public PrivateEndpoint privateEndpoint() {
        return this.innerModel().privateEndpoint();
    }

    public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.innerModel().privateLinkServiceConnectionState();
    }

    public PrivateEndpointConnectionProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public PrivateEndpointConnectionInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String privateEndpointConnectionName;

    private PrivateEndpointConnectionRequest createPrivateEndpointConnectionRequest;

    private PrivateEndpointConnectionRequest updatePrivateEndpointConnectionRequest;

    public PrivateEndpointConnectionImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    public PrivateEndpointConnection create() {
        this.innerObject = serviceManager.serviceClient()
            .getPrivateEndpointConnections()
            .createOrUpdate(resourceGroupName, serviceName, privateEndpointConnectionName,
                createPrivateEndpointConnectionRequest, Context.NONE);
        return this;
    }

    public PrivateEndpointConnection create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getPrivateEndpointConnections()
            .createOrUpdate(resourceGroupName, serviceName, privateEndpointConnectionName,
                createPrivateEndpointConnectionRequest, context);
        return this;
    }

    PrivateEndpointConnectionImpl(String name,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new PrivateEndpointConnectionInner();
        this.serviceManager = serviceManager;
        this.privateEndpointConnectionName = name;
        this.createPrivateEndpointConnectionRequest = new PrivateEndpointConnectionRequest();
    }

    public PrivateEndpointConnectionImpl update() {
        this.updatePrivateEndpointConnectionRequest = new PrivateEndpointConnectionRequest();
        return this;
    }

    public PrivateEndpointConnection apply() {
        this.innerObject = serviceManager.serviceClient()
            .getPrivateEndpointConnections()
            .createOrUpdate(resourceGroupName, serviceName, privateEndpointConnectionName,
                updatePrivateEndpointConnectionRequest, Context.NONE);
        return this;
    }

    public PrivateEndpointConnection apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getPrivateEndpointConnections()
            .createOrUpdate(resourceGroupName, serviceName, privateEndpointConnectionName,
                updatePrivateEndpointConnectionRequest, context);
        return this;
    }

    PrivateEndpointConnectionImpl(PrivateEndpointConnectionInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.privateEndpointConnectionName
            = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "privateEndpointConnections");
    }

    public PrivateEndpointConnection refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getPrivateEndpointConnections()
            .getByNameWithResponse(resourceGroupName, serviceName, privateEndpointConnectionName, Context.NONE)
            .getValue();
        return this;
    }

    public PrivateEndpointConnection refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getPrivateEndpointConnections()
            .getByNameWithResponse(resourceGroupName, serviceName, privateEndpointConnectionName, context)
            .getValue();
        return this;
    }

    public PrivateEndpointConnectionImpl withProperties(PrivateEndpointConnectionRequestProperties properties) {
        if (isInCreateMode()) {
            this.createPrivateEndpointConnectionRequest.withProperties(properties);
            return this;
        } else {
            this.updatePrivateEndpointConnectionRequest.withProperties(properties);
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
