// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.ProductApiLinkContractInner;
import com.azure.resourcemanager.apimanagement.models.ProductApiLinkContract;

public final class ProductApiLinkContractImpl
    implements ProductApiLinkContract, ProductApiLinkContract.Definition, ProductApiLinkContract.Update {
    private ProductApiLinkContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String apiId() {
        return this.innerModel().apiId();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public ProductApiLinkContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String productId;

    private String apiLinkId;

    public ProductApiLinkContractImpl withExistingProduct(String resourceGroupName, String serviceName,
        String productId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.productId = productId;
        return this;
    }

    public ProductApiLinkContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getProductApiLinks()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, productId, apiLinkId, this.innerModel(),
                Context.NONE)
            .getValue();
        return this;
    }

    public ProductApiLinkContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getProductApiLinks()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, productId, apiLinkId, this.innerModel(),
                context)
            .getValue();
        return this;
    }

    ProductApiLinkContractImpl(String name,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new ProductApiLinkContractInner();
        this.serviceManager = serviceManager;
        this.apiLinkId = name;
    }

    public ProductApiLinkContractImpl update() {
        return this;
    }

    public ProductApiLinkContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getProductApiLinks()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, productId, apiLinkId, this.innerModel(),
                Context.NONE)
            .getValue();
        return this;
    }

    public ProductApiLinkContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getProductApiLinks()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, productId, apiLinkId, this.innerModel(),
                context)
            .getValue();
        return this;
    }

    ProductApiLinkContractImpl(ProductApiLinkContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.productId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "products");
        this.apiLinkId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apiLinks");
    }

    public ProductApiLinkContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getProductApiLinks()
            .getWithResponse(resourceGroupName, serviceName, productId, apiLinkId, Context.NONE)
            .getValue();
        return this;
    }

    public ProductApiLinkContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getProductApiLinks()
            .getWithResponse(resourceGroupName, serviceName, productId, apiLinkId, context)
            .getValue();
        return this;
    }

    public ProductApiLinkContractImpl withApiId(String apiId) {
        this.innerModel().withApiId(apiId);
        return this;
    }
}
