// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.ProductApiLinksClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ProductApiLinkContractInner;
import com.azure.resourcemanager.apimanagement.models.ProductApiLinkContract;
import com.azure.resourcemanager.apimanagement.models.ProductApiLinks;
import com.azure.resourcemanager.apimanagement.models.ProductApiLinksGetResponse;

public final class ProductApiLinksImpl implements ProductApiLinks {
    private static final ClientLogger LOGGER = new ClientLogger(ProductApiLinksImpl.class);

    private final ProductApiLinksClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public ProductApiLinksImpl(ProductApiLinksClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<ProductApiLinkContract> listByProduct(String resourceGroupName, String serviceName,
        String productId) {
        PagedIterable<ProductApiLinkContractInner> inner
            = this.serviceClient().listByProduct(resourceGroupName, serviceName, productId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProductApiLinkContractImpl(inner1, this.manager()));
    }

    public PagedIterable<ProductApiLinkContract> listByProduct(String resourceGroupName, String serviceName,
        String productId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<ProductApiLinkContractInner> inner
            = this.serviceClient().listByProduct(resourceGroupName, serviceName, productId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProductApiLinkContractImpl(inner1, this.manager()));
    }

    public Response<ProductApiLinkContract> getWithResponse(String resourceGroupName, String serviceName,
        String productId, String apiLinkId, Context context) {
        ProductApiLinksGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, productId, apiLinkId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ProductApiLinkContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ProductApiLinkContract get(String resourceGroupName, String serviceName, String productId,
        String apiLinkId) {
        ProductApiLinkContractInner inner
            = this.serviceClient().get(resourceGroupName, serviceName, productId, apiLinkId);
        if (inner != null) {
            return new ProductApiLinkContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String productId,
        String apiLinkId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, productId, apiLinkId, context);
    }

    public void delete(String resourceGroupName, String serviceName, String productId, String apiLinkId) {
        this.serviceClient().delete(resourceGroupName, serviceName, productId, apiLinkId);
    }

    public ProductApiLinkContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String productId = ResourceManagerUtils.getValueFromIdByName(id, "products");
        if (productId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'products'.", id)));
        }
        String apiLinkId = ResourceManagerUtils.getValueFromIdByName(id, "apiLinks");
        if (apiLinkId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apiLinks'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, productId, apiLinkId, Context.NONE).getValue();
    }

    public Response<ProductApiLinkContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String productId = ResourceManagerUtils.getValueFromIdByName(id, "products");
        if (productId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'products'.", id)));
        }
        String apiLinkId = ResourceManagerUtils.getValueFromIdByName(id, "apiLinks");
        if (apiLinkId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apiLinks'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, productId, apiLinkId, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String productId = ResourceManagerUtils.getValueFromIdByName(id, "products");
        if (productId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'products'.", id)));
        }
        String apiLinkId = ResourceManagerUtils.getValueFromIdByName(id, "apiLinks");
        if (apiLinkId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apiLinks'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, serviceName, productId, apiLinkId, Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String productId = ResourceManagerUtils.getValueFromIdByName(id, "products");
        if (productId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'products'.", id)));
        }
        String apiLinkId = ResourceManagerUtils.getValueFromIdByName(id, "apiLinks");
        if (apiLinkId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apiLinks'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, productId, apiLinkId, context);
    }

    private ProductApiLinksClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    public ProductApiLinkContractImpl define(String name) {
        return new ProductApiLinkContractImpl(name, this.manager());
    }
}
