// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.ProductApisClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiContractInner;
import com.azure.resourcemanager.apimanagement.models.ApiContract;
import com.azure.resourcemanager.apimanagement.models.ProductApis;

public final class ProductApisImpl implements ProductApis {
    private static final ClientLogger LOGGER = new ClientLogger(ProductApisImpl.class);

    private final ProductApisClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public ProductApisImpl(ProductApisClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<ApiContract> listByProduct(String resourceGroupName, String serviceName, String productId) {
        PagedIterable<ApiContractInner> inner
            = this.serviceClient().listByProduct(resourceGroupName, serviceName, productId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiContractImpl(inner1, this.manager()));
    }

    public PagedIterable<ApiContract> listByProduct(String resourceGroupName, String serviceName, String productId,
        String filter, Integer top, Integer skip, Context context) {
        PagedIterable<ApiContractInner> inner
            = this.serviceClient().listByProduct(resourceGroupName, serviceName, productId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiContractImpl(inner1, this.manager()));
    }

    public Response<Void> checkEntityExistsWithResponse(String resourceGroupName, String serviceName, String productId,
        String apiId, Context context) {
        return this.serviceClient()
            .checkEntityExistsWithResponse(resourceGroupName, serviceName, productId, apiId, context);
    }

    public void checkEntityExists(String resourceGroupName, String serviceName, String productId, String apiId) {
        this.serviceClient().checkEntityExists(resourceGroupName, serviceName, productId, apiId);
    }

    public Response<ApiContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName,
        String productId, String apiId, Context context) {
        Response<ApiContractInner> inner = this.serviceClient()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, productId, apiId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ApiContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ApiContract createOrUpdate(String resourceGroupName, String serviceName, String productId, String apiId) {
        ApiContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, productId, apiId);
        if (inner != null) {
            return new ApiContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String productId,
        String apiId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, productId, apiId, context);
    }

    public void delete(String resourceGroupName, String serviceName, String productId, String apiId) {
        this.serviceClient().delete(resourceGroupName, serviceName, productId, apiId);
    }

    private ProductApisClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
