// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.ProductContractInner;
import com.azure.resourcemanager.apimanagement.models.ProductContract;
import com.azure.resourcemanager.apimanagement.models.ProductState;
import com.azure.resourcemanager.apimanagement.models.ProductUpdateParameters;

public final class ProductContractImpl implements ProductContract, ProductContract.Definition, ProductContract.Update {
    private ProductContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String displayName() {
        return this.innerModel().displayName();
    }

    public String description() {
        return this.innerModel().description();
    }

    public String terms() {
        return this.innerModel().terms();
    }

    public Boolean subscriptionRequired() {
        return this.innerModel().subscriptionRequired();
    }

    public Boolean approvalRequired() {
        return this.innerModel().approvalRequired();
    }

    public Integer subscriptionsLimit() {
        return this.innerModel().subscriptionsLimit();
    }

    public ProductState state() {
        return this.innerModel().state();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public ProductContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String productId;

    private String createIfMatch;

    private String updateIfMatch;

    private ProductUpdateParameters updateParameters;

    public ProductContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    public ProductContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getProducts()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, productId, this.innerModel(), createIfMatch,
                Context.NONE)
            .getValue();
        return this;
    }

    public ProductContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getProducts()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, productId, this.innerModel(), createIfMatch,
                context)
            .getValue();
        return this;
    }

    ProductContractImpl(String name, com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new ProductContractInner();
        this.serviceManager = serviceManager;
        this.productId = name;
        this.createIfMatch = null;
    }

    public ProductContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new ProductUpdateParameters();
        return this;
    }

    public ProductContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getProducts()
            .updateWithResponse(resourceGroupName, serviceName, productId, updateIfMatch, updateParameters,
                Context.NONE)
            .getValue();
        return this;
    }

    public ProductContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getProducts()
            .updateWithResponse(resourceGroupName, serviceName, productId, updateIfMatch, updateParameters, context)
            .getValue();
        return this;
    }

    ProductContractImpl(ProductContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.productId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "products");
    }

    public ProductContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getProducts()
            .getWithResponse(resourceGroupName, serviceName, productId, Context.NONE)
            .getValue();
        return this;
    }

    public ProductContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getProducts()
            .getWithResponse(resourceGroupName, serviceName, productId, context)
            .getValue();
        return this;
    }

    public ProductContractImpl withDisplayName(String displayName) {
        if (isInCreateMode()) {
            this.innerModel().withDisplayName(displayName);
            return this;
        } else {
            this.updateParameters.withDisplayName(displayName);
            return this;
        }
    }

    public ProductContractImpl withDescription(String description) {
        if (isInCreateMode()) {
            this.innerModel().withDescription(description);
            return this;
        } else {
            this.updateParameters.withDescription(description);
            return this;
        }
    }

    public ProductContractImpl withTerms(String terms) {
        if (isInCreateMode()) {
            this.innerModel().withTerms(terms);
            return this;
        } else {
            this.updateParameters.withTerms(terms);
            return this;
        }
    }

    public ProductContractImpl withSubscriptionRequired(Boolean subscriptionRequired) {
        if (isInCreateMode()) {
            this.innerModel().withSubscriptionRequired(subscriptionRequired);
            return this;
        } else {
            this.updateParameters.withSubscriptionRequired(subscriptionRequired);
            return this;
        }
    }

    public ProductContractImpl withApprovalRequired(Boolean approvalRequired) {
        if (isInCreateMode()) {
            this.innerModel().withApprovalRequired(approvalRequired);
            return this;
        } else {
            this.updateParameters.withApprovalRequired(approvalRequired);
            return this;
        }
    }

    public ProductContractImpl withSubscriptionsLimit(Integer subscriptionsLimit) {
        if (isInCreateMode()) {
            this.innerModel().withSubscriptionsLimit(subscriptionsLimit);
            return this;
        } else {
            this.updateParameters.withSubscriptionsLimit(subscriptionsLimit);
            return this;
        }
    }

    public ProductContractImpl withState(ProductState state) {
        if (isInCreateMode()) {
            this.innerModel().withState(state);
            return this;
        } else {
            this.updateParameters.withState(state);
            return this;
        }
    }

    public ProductContractImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
