// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.ProductGroupLinkContractInner;
import com.azure.resourcemanager.apimanagement.models.ProductGroupLinkContract;

public final class ProductGroupLinkContractImpl
    implements ProductGroupLinkContract, ProductGroupLinkContract.Definition, ProductGroupLinkContract.Update {
    private ProductGroupLinkContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String groupId() {
        return this.innerModel().groupId();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public ProductGroupLinkContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String productId;

    private String groupLinkId;

    public ProductGroupLinkContractImpl withExistingProduct(String resourceGroupName, String serviceName,
        String productId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.productId = productId;
        return this;
    }

    public ProductGroupLinkContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getProductGroupLinks()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, productId, groupLinkId, this.innerModel(),
                Context.NONE)
            .getValue();
        return this;
    }

    public ProductGroupLinkContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getProductGroupLinks()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, productId, groupLinkId, this.innerModel(),
                context)
            .getValue();
        return this;
    }

    ProductGroupLinkContractImpl(String name,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new ProductGroupLinkContractInner();
        this.serviceManager = serviceManager;
        this.groupLinkId = name;
    }

    public ProductGroupLinkContractImpl update() {
        return this;
    }

    public ProductGroupLinkContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getProductGroupLinks()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, productId, groupLinkId, this.innerModel(),
                Context.NONE)
            .getValue();
        return this;
    }

    public ProductGroupLinkContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getProductGroupLinks()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, productId, groupLinkId, this.innerModel(),
                context)
            .getValue();
        return this;
    }

    ProductGroupLinkContractImpl(ProductGroupLinkContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.productId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "products");
        this.groupLinkId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "groupLinks");
    }

    public ProductGroupLinkContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getProductGroupLinks()
            .getWithResponse(resourceGroupName, serviceName, productId, groupLinkId, Context.NONE)
            .getValue();
        return this;
    }

    public ProductGroupLinkContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getProductGroupLinks()
            .getWithResponse(resourceGroupName, serviceName, productId, groupLinkId, context)
            .getValue();
        return this;
    }

    public ProductGroupLinkContractImpl withGroupId(String groupId) {
        this.innerModel().withGroupId(groupId);
        return this;
    }
}
