// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.ProductGroupLinksClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ProductGroupLinkContractInner;
import com.azure.resourcemanager.apimanagement.models.ProductGroupLinkContract;
import com.azure.resourcemanager.apimanagement.models.ProductGroupLinks;
import com.azure.resourcemanager.apimanagement.models.ProductGroupLinksGetResponse;

public final class ProductGroupLinksImpl implements ProductGroupLinks {
    private static final ClientLogger LOGGER = new ClientLogger(ProductGroupLinksImpl.class);

    private final ProductGroupLinksClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public ProductGroupLinksImpl(ProductGroupLinksClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<ProductGroupLinkContract> listByProduct(String resourceGroupName, String serviceName,
        String productId) {
        PagedIterable<ProductGroupLinkContractInner> inner
            = this.serviceClient().listByProduct(resourceGroupName, serviceName, productId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProductGroupLinkContractImpl(inner1, this.manager()));
    }

    public PagedIterable<ProductGroupLinkContract> listByProduct(String resourceGroupName, String serviceName,
        String productId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<ProductGroupLinkContractInner> inner
            = this.serviceClient().listByProduct(resourceGroupName, serviceName, productId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProductGroupLinkContractImpl(inner1, this.manager()));
    }

    public Response<ProductGroupLinkContract> getWithResponse(String resourceGroupName, String serviceName,
        String productId, String groupLinkId, Context context) {
        ProductGroupLinksGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, productId, groupLinkId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ProductGroupLinkContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ProductGroupLinkContract get(String resourceGroupName, String serviceName, String productId,
        String groupLinkId) {
        ProductGroupLinkContractInner inner
            = this.serviceClient().get(resourceGroupName, serviceName, productId, groupLinkId);
        if (inner != null) {
            return new ProductGroupLinkContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String productId,
        String groupLinkId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, productId, groupLinkId, context);
    }

    public void delete(String resourceGroupName, String serviceName, String productId, String groupLinkId) {
        this.serviceClient().delete(resourceGroupName, serviceName, productId, groupLinkId);
    }

    public ProductGroupLinkContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String productId = ResourceManagerUtils.getValueFromIdByName(id, "products");
        if (productId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'products'.", id)));
        }
        String groupLinkId = ResourceManagerUtils.getValueFromIdByName(id, "groupLinks");
        if (groupLinkId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'groupLinks'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, productId, groupLinkId, Context.NONE).getValue();
    }

    public Response<ProductGroupLinkContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String productId = ResourceManagerUtils.getValueFromIdByName(id, "products");
        if (productId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'products'.", id)));
        }
        String groupLinkId = ResourceManagerUtils.getValueFromIdByName(id, "groupLinks");
        if (groupLinkId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'groupLinks'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, productId, groupLinkId, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String productId = ResourceManagerUtils.getValueFromIdByName(id, "products");
        if (productId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'products'.", id)));
        }
        String groupLinkId = ResourceManagerUtils.getValueFromIdByName(id, "groupLinks");
        if (groupLinkId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'groupLinks'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, serviceName, productId, groupLinkId, Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String productId = ResourceManagerUtils.getValueFromIdByName(id, "products");
        if (productId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'products'.", id)));
        }
        String groupLinkId = ResourceManagerUtils.getValueFromIdByName(id, "groupLinks");
        if (groupLinkId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'groupLinks'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, productId, groupLinkId, context);
    }

    private ProductGroupLinksClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    public ProductGroupLinkContractImpl define(String name) {
        return new ProductGroupLinkContractImpl(name, this.manager());
    }
}
