// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.resourcemanager.apimanagement.fluent.models.RecipientEmailCollectionInner;
import com.azure.resourcemanager.apimanagement.fluent.models.RecipientEmailContractInner;
import com.azure.resourcemanager.apimanagement.models.RecipientEmailCollection;
import com.azure.resourcemanager.apimanagement.models.RecipientEmailContract;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class RecipientEmailCollectionImpl implements RecipientEmailCollection {
    private RecipientEmailCollectionInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    RecipientEmailCollectionImpl(RecipientEmailCollectionInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    public List<RecipientEmailContract> value() {
        List<RecipientEmailContractInner> inner = this.innerModel().value();
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream()
                .map(inner1 -> new RecipientEmailContractImpl(inner1, this.manager()))
                .collect(Collectors.toList()));
        } else {
            return Collections.emptyList();
        }
    }

    public Long count() {
        return this.innerModel().count();
    }

    public String nextLink() {
        return this.innerModel().nextLink();
    }

    public RecipientEmailCollectionInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
