// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.resourcemanager.apimanagement.fluent.models.RecipientUserCollectionInner;
import com.azure.resourcemanager.apimanagement.fluent.models.RecipientUserContractInner;
import com.azure.resourcemanager.apimanagement.models.RecipientUserCollection;
import com.azure.resourcemanager.apimanagement.models.RecipientUserContract;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class RecipientUserCollectionImpl implements RecipientUserCollection {
    private RecipientUserCollectionInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    RecipientUserCollectionImpl(RecipientUserCollectionInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    public List<RecipientUserContract> value() {
        List<RecipientUserContractInner> inner = this.innerModel().value();
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream()
                .map(inner1 -> new RecipientUserContractImpl(inner1, this.manager()))
                .collect(Collectors.toList()));
        } else {
            return Collections.emptyList();
        }
    }

    public Long count() {
        return this.innerModel().count();
    }

    public String nextLink() {
        return this.innerModel().nextLink();
    }

    public RecipientUserCollectionInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
