// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.apimanagement.fluent.ReportsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ReportRecordContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.RequestReportRecordContractInner;
import com.azure.resourcemanager.apimanagement.models.ReportCollection;
import com.azure.resourcemanager.apimanagement.models.RequestReportCollection;
import java.time.Duration;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in ReportsClient.
 */
public final class ReportsClientImpl implements ReportsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final ReportsService service;

    /**
     * The service client containing this operation class.
     */
    private final ApiManagementClientImpl client;

    /**
     * Initializes an instance of ReportsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    ReportsClientImpl(ApiManagementClientImpl client) {
        this.service = RestProxy.create(ReportsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ApiManagementClientReports to be used by the proxy service to perform
     * REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ApiManagementClientR")
    public interface ReportsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/reports/byApi")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ReportCollection>> listByApi(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serviceName") String serviceName,
            @QueryParam("$filter") String filter, @QueryParam("$top") Integer top, @QueryParam("$skip") Integer skip,
            @QueryParam("$orderby") String orderby, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/reports/byUser")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ReportCollection>> listByUser(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serviceName") String serviceName,
            @QueryParam("$filter") String filter, @QueryParam("$top") Integer top, @QueryParam("$skip") Integer skip,
            @QueryParam("$orderby") String orderby, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/reports/byOperation")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ReportCollection>> listByOperation(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serviceName") String serviceName,
            @QueryParam("$filter") String filter, @QueryParam("$top") Integer top, @QueryParam("$skip") Integer skip,
            @QueryParam("$orderby") String orderby, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/reports/byProduct")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ReportCollection>> listByProduct(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serviceName") String serviceName,
            @QueryParam("$filter") String filter, @QueryParam("$top") Integer top, @QueryParam("$skip") Integer skip,
            @QueryParam("$orderby") String orderby, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/reports/byGeo")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ReportCollection>> listByGeo(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serviceName") String serviceName,
            @QueryParam("$filter") String filter, @QueryParam("$top") Integer top, @QueryParam("$skip") Integer skip,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/reports/bySubscription")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ReportCollection>> listBySubscription(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serviceName") String serviceName,
            @QueryParam("$filter") String filter, @QueryParam("$top") Integer top, @QueryParam("$skip") Integer skip,
            @QueryParam("$orderby") String orderby, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/reports/byTime")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ReportCollection>> listByTime(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serviceName") String serviceName,
            @QueryParam("$filter") String filter, @QueryParam("$top") Integer top, @QueryParam("$skip") Integer skip,
            @QueryParam("$orderby") String orderby, @QueryParam("interval") Duration interval,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/reports/byRequest")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RequestReportCollection>> listByRequest(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serviceName") String serviceName,
            @QueryParam("$filter") String filter, @QueryParam("$top") Integer top, @QueryParam("$skip") Integer skip,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ReportCollection>> listByApiNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ReportCollection>> listByUserNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ReportCollection>> listByOperationNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ReportCollection>> listByProductNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ReportCollection>> listByGeoNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ReportCollection>> listBySubscriptionNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ReportCollection>> listByTimeNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint, @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Lists report records by API.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter The filter to apply on the operation.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listByApiSinglePageAsync(String resourceGroupName,
        String serviceName, String filter, Integer top, Integer skip, String orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error(new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByApi(this.client.getEndpoint(), resourceGroupName, serviceName, filter,
                top, skip, orderby, this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .<PagedResponse<ReportRecordContractInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists report records by API.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter The filter to apply on the operation.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listByApiSinglePageAsync(String resourceGroupName,
        String serviceName, String filter, Integer top, Integer skip, String orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error(new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByApi(this.client.getEndpoint(), resourceGroupName, serviceName, filter, top, skip, orderby,
                this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists report records by API.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter The filter to apply on the operation.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ReportRecordContractInner> listByApiAsync(String resourceGroupName, String serviceName,
        String filter, Integer top, Integer skip, String orderby) {
        return new PagedFlux<>(
            () -> listByApiSinglePageAsync(resourceGroupName, serviceName, filter, top, skip, orderby),
            nextLink -> listByApiNextSinglePageAsync(nextLink));
    }

    /**
     * Lists report records by API.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter The filter to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ReportRecordContractInner> listByApiAsync(String resourceGroupName, String serviceName,
        String filter) {
        final Integer top = null;
        final Integer skip = null;
        final String orderby = null;
        return new PagedFlux<>(
            () -> listByApiSinglePageAsync(resourceGroupName, serviceName, filter, top, skip, orderby),
            nextLink -> listByApiNextSinglePageAsync(nextLink));
    }

    /**
     * Lists report records by API.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter The filter to apply on the operation.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ReportRecordContractInner> listByApiAsync(String resourceGroupName, String serviceName,
        String filter, Integer top, Integer skip, String orderby, Context context) {
        return new PagedFlux<>(
            () -> listByApiSinglePageAsync(resourceGroupName, serviceName, filter, top, skip, orderby, context),
            nextLink -> listByApiNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists report records by API.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter The filter to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ReportRecordContractInner> listByApi(String resourceGroupName, String serviceName,
        String filter) {
        final Integer top = null;
        final Integer skip = null;
        final String orderby = null;
        return new PagedIterable<>(listByApiAsync(resourceGroupName, serviceName, filter, top, skip, orderby));
    }

    /**
     * Lists report records by API.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter The filter to apply on the operation.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ReportRecordContractInner> listByApi(String resourceGroupName, String serviceName,
        String filter, Integer top, Integer skip, String orderby, Context context) {
        return new PagedIterable<>(listByApiAsync(resourceGroupName, serviceName, filter, top, skip, orderby, context));
    }

    /**
     * Lists report records by User.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| userId | select, filter | eq | | &lt;/br&gt;|
     * apiRegion | filter | eq | | &lt;/br&gt;| productId | filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq |
     * | &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | filter | eq | | &lt;/br&gt;| callCountSuccess |
     * select, orderBy | | | &lt;/br&gt;| callCountBlocked | select, orderBy | | | &lt;/br&gt;| callCountFailed |
     * select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy | | | &lt;/br&gt;| callCountTotal | select,
     * orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;| cacheHitsCount | select | | |
     * &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select, orderBy | | | &lt;/br&gt;|
     * apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;| serviceTimeAvg | select | | |
     * &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | | | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listByUserSinglePageAsync(String resourceGroupName,
        String serviceName, String filter, Integer top, Integer skip, String orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error(new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByUser(this.client.getEndpoint(), resourceGroupName, serviceName, filter, top,
                    skip, orderby, this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .<PagedResponse<ReportRecordContractInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists report records by User.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| userId | select, filter | eq | | &lt;/br&gt;|
     * apiRegion | filter | eq | | &lt;/br&gt;| productId | filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq |
     * | &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | filter | eq | | &lt;/br&gt;| callCountSuccess |
     * select, orderBy | | | &lt;/br&gt;| callCountBlocked | select, orderBy | | | &lt;/br&gt;| callCountFailed |
     * select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy | | | &lt;/br&gt;| callCountTotal | select,
     * orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;| cacheHitsCount | select | | |
     * &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select, orderBy | | | &lt;/br&gt;|
     * apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;| serviceTimeAvg | select | | |
     * &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | | | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listByUserSinglePageAsync(String resourceGroupName,
        String serviceName, String filter, Integer top, Integer skip, String orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error(new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByUser(this.client.getEndpoint(), resourceGroupName, serviceName, filter, top, skip, orderby,
                this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists report records by User.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| userId | select, filter | eq | | &lt;/br&gt;|
     * apiRegion | filter | eq | | &lt;/br&gt;| productId | filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq |
     * | &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | filter | eq | | &lt;/br&gt;| callCountSuccess |
     * select, orderBy | | | &lt;/br&gt;| callCountBlocked | select, orderBy | | | &lt;/br&gt;| callCountFailed |
     * select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy | | | &lt;/br&gt;| callCountTotal | select,
     * orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;| cacheHitsCount | select | | |
     * &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select, orderBy | | | &lt;/br&gt;|
     * apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;| serviceTimeAvg | select | | |
     * &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | | | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ReportRecordContractInner> listByUserAsync(String resourceGroupName, String serviceName,
        String filter, Integer top, Integer skip, String orderby) {
        return new PagedFlux<>(
            () -> listByUserSinglePageAsync(resourceGroupName, serviceName, filter, top, skip, orderby),
            nextLink -> listByUserNextSinglePageAsync(nextLink));
    }

    /**
     * Lists report records by User.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| userId | select, filter | eq | | &lt;/br&gt;|
     * apiRegion | filter | eq | | &lt;/br&gt;| productId | filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq |
     * | &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | filter | eq | | &lt;/br&gt;| callCountSuccess |
     * select, orderBy | | | &lt;/br&gt;| callCountBlocked | select, orderBy | | | &lt;/br&gt;| callCountFailed |
     * select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy | | | &lt;/br&gt;| callCountTotal | select,
     * orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;| cacheHitsCount | select | | |
     * &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select, orderBy | | | &lt;/br&gt;|
     * apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;| serviceTimeAvg | select | | |
     * &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | | | &lt;/br&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ReportRecordContractInner> listByUserAsync(String resourceGroupName, String serviceName,
        String filter) {
        final Integer top = null;
        final Integer skip = null;
        final String orderby = null;
        return new PagedFlux<>(
            () -> listByUserSinglePageAsync(resourceGroupName, serviceName, filter, top, skip, orderby),
            nextLink -> listByUserNextSinglePageAsync(nextLink));
    }

    /**
     * Lists report records by User.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| userId | select, filter | eq | | &lt;/br&gt;|
     * apiRegion | filter | eq | | &lt;/br&gt;| productId | filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq |
     * | &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | filter | eq | | &lt;/br&gt;| callCountSuccess |
     * select, orderBy | | | &lt;/br&gt;| callCountBlocked | select, orderBy | | | &lt;/br&gt;| callCountFailed |
     * select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy | | | &lt;/br&gt;| callCountTotal | select,
     * orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;| cacheHitsCount | select | | |
     * &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select, orderBy | | | &lt;/br&gt;|
     * apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;| serviceTimeAvg | select | | |
     * &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | | | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ReportRecordContractInner> listByUserAsync(String resourceGroupName, String serviceName,
        String filter, Integer top, Integer skip, String orderby, Context context) {
        return new PagedFlux<>(
            () -> listByUserSinglePageAsync(resourceGroupName, serviceName, filter, top, skip, orderby, context),
            nextLink -> listByUserNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists report records by User.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| userId | select, filter | eq | | &lt;/br&gt;|
     * apiRegion | filter | eq | | &lt;/br&gt;| productId | filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq |
     * | &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | filter | eq | | &lt;/br&gt;| callCountSuccess |
     * select, orderBy | | | &lt;/br&gt;| callCountBlocked | select, orderBy | | | &lt;/br&gt;| callCountFailed |
     * select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy | | | &lt;/br&gt;| callCountTotal | select,
     * orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;| cacheHitsCount | select | | |
     * &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select, orderBy | | | &lt;/br&gt;|
     * apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;| serviceTimeAvg | select | | |
     * &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | | | &lt;/br&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ReportRecordContractInner> listByUser(String resourceGroupName, String serviceName,
        String filter) {
        final Integer top = null;
        final Integer skip = null;
        final String orderby = null;
        return new PagedIterable<>(listByUserAsync(resourceGroupName, serviceName, filter, top, skip, orderby));
    }

    /**
     * Lists report records by User.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| userId | select, filter | eq | | &lt;/br&gt;|
     * apiRegion | filter | eq | | &lt;/br&gt;| productId | filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq |
     * | &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | filter | eq | | &lt;/br&gt;| callCountSuccess |
     * select, orderBy | | | &lt;/br&gt;| callCountBlocked | select, orderBy | | | &lt;/br&gt;| callCountFailed |
     * select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy | | | &lt;/br&gt;| callCountTotal | select,
     * orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;| cacheHitsCount | select | | |
     * &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select, orderBy | | | &lt;/br&gt;|
     * apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;| serviceTimeAvg | select | | |
     * &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | | | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ReportRecordContractInner> listByUser(String resourceGroupName, String serviceName,
        String filter, Integer top, Integer skip, String orderby, Context context) {
        return new PagedIterable<>(
            listByUserAsync(resourceGroupName, serviceName, filter, top, skip, orderby, context));
    }

    /**
     * Lists report records by API Operations.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * filter | eq | | &lt;/br&gt;| productId | filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq | |
     * &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | select, filter | eq | | &lt;/br&gt;|
     * callCountSuccess | select, orderBy | | | &lt;/br&gt;| callCountBlocked | select, orderBy | | | &lt;/br&gt;|
     * callCountFailed | select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy | | | &lt;/br&gt;|
     * callCountTotal | select, orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;| cacheHitsCount
     * | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select, orderBy | | |
     * &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;| serviceTimeAvg |
     * select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | | | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listByOperationSinglePageAsync(String resourceGroupName,
        String serviceName, String filter, Integer top, Integer skip, String orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error(new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByOperation(this.client.getEndpoint(), resourceGroupName, serviceName, filter,
                    top, skip, orderby, this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .<PagedResponse<ReportRecordContractInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists report records by API Operations.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * filter | eq | | &lt;/br&gt;| productId | filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq | |
     * &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | select, filter | eq | | &lt;/br&gt;|
     * callCountSuccess | select, orderBy | | | &lt;/br&gt;| callCountBlocked | select, orderBy | | | &lt;/br&gt;|
     * callCountFailed | select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy | | | &lt;/br&gt;|
     * callCountTotal | select, orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;| cacheHitsCount
     * | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select, orderBy | | |
     * &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;| serviceTimeAvg |
     * select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | | | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listByOperationSinglePageAsync(String resourceGroupName,
        String serviceName, String filter, Integer top, Integer skip, String orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error(new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByOperation(this.client.getEndpoint(), resourceGroupName, serviceName, filter, top, skip, orderby,
                this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists report records by API Operations.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * filter | eq | | &lt;/br&gt;| productId | filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq | |
     * &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | select, filter | eq | | &lt;/br&gt;|
     * callCountSuccess | select, orderBy | | | &lt;/br&gt;| callCountBlocked | select, orderBy | | | &lt;/br&gt;|
     * callCountFailed | select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy | | | &lt;/br&gt;|
     * callCountTotal | select, orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;| cacheHitsCount
     * | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select, orderBy | | |
     * &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;| serviceTimeAvg |
     * select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | | | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ReportRecordContractInner> listByOperationAsync(String resourceGroupName, String serviceName,
        String filter, Integer top, Integer skip, String orderby) {
        return new PagedFlux<>(
            () -> listByOperationSinglePageAsync(resourceGroupName, serviceName, filter, top, skip, orderby),
            nextLink -> listByOperationNextSinglePageAsync(nextLink));
    }

    /**
     * Lists report records by API Operations.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * filter | eq | | &lt;/br&gt;| productId | filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq | |
     * &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | select, filter | eq | | &lt;/br&gt;|
     * callCountSuccess | select, orderBy | | | &lt;/br&gt;| callCountBlocked | select, orderBy | | | &lt;/br&gt;|
     * callCountFailed | select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy | | | &lt;/br&gt;|
     * callCountTotal | select, orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;| cacheHitsCount
     * | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select, orderBy | | |
     * &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;| serviceTimeAvg |
     * select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | | | &lt;/br&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ReportRecordContractInner> listByOperationAsync(String resourceGroupName, String serviceName,
        String filter) {
        final Integer top = null;
        final Integer skip = null;
        final String orderby = null;
        return new PagedFlux<>(
            () -> listByOperationSinglePageAsync(resourceGroupName, serviceName, filter, top, skip, orderby),
            nextLink -> listByOperationNextSinglePageAsync(nextLink));
    }

    /**
     * Lists report records by API Operations.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * filter | eq | | &lt;/br&gt;| productId | filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq | |
     * &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | select, filter | eq | | &lt;/br&gt;|
     * callCountSuccess | select, orderBy | | | &lt;/br&gt;| callCountBlocked | select, orderBy | | | &lt;/br&gt;|
     * callCountFailed | select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy | | | &lt;/br&gt;|
     * callCountTotal | select, orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;| cacheHitsCount
     * | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select, orderBy | | |
     * &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;| serviceTimeAvg |
     * select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | | | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ReportRecordContractInner> listByOperationAsync(String resourceGroupName, String serviceName,
        String filter, Integer top, Integer skip, String orderby, Context context) {
        return new PagedFlux<>(
            () -> listByOperationSinglePageAsync(resourceGroupName, serviceName, filter, top, skip, orderby, context),
            nextLink -> listByOperationNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists report records by API Operations.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * filter | eq | | &lt;/br&gt;| productId | filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq | |
     * &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | select, filter | eq | | &lt;/br&gt;|
     * callCountSuccess | select, orderBy | | | &lt;/br&gt;| callCountBlocked | select, orderBy | | | &lt;/br&gt;|
     * callCountFailed | select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy | | | &lt;/br&gt;|
     * callCountTotal | select, orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;| cacheHitsCount
     * | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select, orderBy | | |
     * &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;| serviceTimeAvg |
     * select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | | | &lt;/br&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ReportRecordContractInner> listByOperation(String resourceGroupName, String serviceName,
        String filter) {
        final Integer top = null;
        final Integer skip = null;
        final String orderby = null;
        return new PagedIterable<>(listByOperationAsync(resourceGroupName, serviceName, filter, top, skip, orderby));
    }

    /**
     * Lists report records by API Operations.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * filter | eq | | &lt;/br&gt;| productId | filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq | |
     * &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | select, filter | eq | | &lt;/br&gt;|
     * callCountSuccess | select, orderBy | | | &lt;/br&gt;| callCountBlocked | select, orderBy | | | &lt;/br&gt;|
     * callCountFailed | select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy | | | &lt;/br&gt;|
     * callCountTotal | select, orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;| cacheHitsCount
     * | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select, orderBy | | |
     * &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;| serviceTimeAvg |
     * select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | | | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ReportRecordContractInner> listByOperation(String resourceGroupName, String serviceName,
        String filter, Integer top, Integer skip, String orderby, Context context) {
        return new PagedIterable<>(
            listByOperationAsync(resourceGroupName, serviceName, filter, top, skip, orderby, context));
    }

    /**
     * Lists report records by Product.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * filter | eq | | &lt;/br&gt;| productId | select, filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq | |
     * &lt;/br&gt;| callCountSuccess | select, orderBy | | | &lt;/br&gt;| callCountBlocked | select, orderBy | | |
     * &lt;/br&gt;| callCountFailed | select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy | | |
     * &lt;/br&gt;| callCountTotal | select, orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;|
     * cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select,
     * orderBy | | | &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;|
     * serviceTimeAvg | select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | |
     * | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listByProductSinglePageAsync(String resourceGroupName,
        String serviceName, String filter, Integer top, Integer skip, String orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error(new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByProduct(this.client.getEndpoint(), resourceGroupName, serviceName, filter, top,
                    skip, orderby, this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .<PagedResponse<ReportRecordContractInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists report records by Product.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * filter | eq | | &lt;/br&gt;| productId | select, filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq | |
     * &lt;/br&gt;| callCountSuccess | select, orderBy | | | &lt;/br&gt;| callCountBlocked | select, orderBy | | |
     * &lt;/br&gt;| callCountFailed | select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy | | |
     * &lt;/br&gt;| callCountTotal | select, orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;|
     * cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select,
     * orderBy | | | &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;|
     * serviceTimeAvg | select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | |
     * | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listByProductSinglePageAsync(String resourceGroupName,
        String serviceName, String filter, Integer top, Integer skip, String orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error(new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByProduct(this.client.getEndpoint(), resourceGroupName, serviceName, filter, top, skip, orderby,
                this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists report records by Product.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * filter | eq | | &lt;/br&gt;| productId | select, filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq | |
     * &lt;/br&gt;| callCountSuccess | select, orderBy | | | &lt;/br&gt;| callCountBlocked | select, orderBy | | |
     * &lt;/br&gt;| callCountFailed | select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy | | |
     * &lt;/br&gt;| callCountTotal | select, orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;|
     * cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select,
     * orderBy | | | &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;|
     * serviceTimeAvg | select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | |
     * | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ReportRecordContractInner> listByProductAsync(String resourceGroupName, String serviceName,
        String filter, Integer top, Integer skip, String orderby) {
        return new PagedFlux<>(
            () -> listByProductSinglePageAsync(resourceGroupName, serviceName, filter, top, skip, orderby),
            nextLink -> listByProductNextSinglePageAsync(nextLink));
    }

    /**
     * Lists report records by Product.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * filter | eq | | &lt;/br&gt;| productId | select, filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq | |
     * &lt;/br&gt;| callCountSuccess | select, orderBy | | | &lt;/br&gt;| callCountBlocked | select, orderBy | | |
     * &lt;/br&gt;| callCountFailed | select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy | | |
     * &lt;/br&gt;| callCountTotal | select, orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;|
     * cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select,
     * orderBy | | | &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;|
     * serviceTimeAvg | select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | |
     * | &lt;/br&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ReportRecordContractInner> listByProductAsync(String resourceGroupName, String serviceName,
        String filter) {
        final Integer top = null;
        final Integer skip = null;
        final String orderby = null;
        return new PagedFlux<>(
            () -> listByProductSinglePageAsync(resourceGroupName, serviceName, filter, top, skip, orderby),
            nextLink -> listByProductNextSinglePageAsync(nextLink));
    }

    /**
     * Lists report records by Product.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * filter | eq | | &lt;/br&gt;| productId | select, filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq | |
     * &lt;/br&gt;| callCountSuccess | select, orderBy | | | &lt;/br&gt;| callCountBlocked | select, orderBy | | |
     * &lt;/br&gt;| callCountFailed | select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy | | |
     * &lt;/br&gt;| callCountTotal | select, orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;|
     * cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select,
     * orderBy | | | &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;|
     * serviceTimeAvg | select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | |
     * | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ReportRecordContractInner> listByProductAsync(String resourceGroupName, String serviceName,
        String filter, Integer top, Integer skip, String orderby, Context context) {
        return new PagedFlux<>(
            () -> listByProductSinglePageAsync(resourceGroupName, serviceName, filter, top, skip, orderby, context),
            nextLink -> listByProductNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists report records by Product.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * filter | eq | | &lt;/br&gt;| productId | select, filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq | |
     * &lt;/br&gt;| callCountSuccess | select, orderBy | | | &lt;/br&gt;| callCountBlocked | select, orderBy | | |
     * &lt;/br&gt;| callCountFailed | select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy | | |
     * &lt;/br&gt;| callCountTotal | select, orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;|
     * cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select,
     * orderBy | | | &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;|
     * serviceTimeAvg | select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | |
     * | &lt;/br&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ReportRecordContractInner> listByProduct(String resourceGroupName, String serviceName,
        String filter) {
        final Integer top = null;
        final Integer skip = null;
        final String orderby = null;
        return new PagedIterable<>(listByProductAsync(resourceGroupName, serviceName, filter, top, skip, orderby));
    }

    /**
     * Lists report records by Product.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * filter | eq | | &lt;/br&gt;| productId | select, filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq | |
     * &lt;/br&gt;| callCountSuccess | select, orderBy | | | &lt;/br&gt;| callCountBlocked | select, orderBy | | |
     * &lt;/br&gt;| callCountFailed | select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy | | |
     * &lt;/br&gt;| callCountTotal | select, orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;|
     * cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select,
     * orderBy | | | &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;|
     * serviceTimeAvg | select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | |
     * | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ReportRecordContractInner> listByProduct(String resourceGroupName, String serviceName,
        String filter, Integer top, Integer skip, String orderby, Context context) {
        return new PagedIterable<>(
            listByProductAsync(resourceGroupName, serviceName, filter, top, skip, orderby, context));
    }

    /**
     * Lists report records by geography.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| country | select | | | &lt;/br&gt;| region | select | | | &lt;/br&gt;| zip | select | | |
     * &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId | filter | eq | | &lt;/br&gt;| productId | filter |
     * eq | | &lt;/br&gt;| subscriptionId | filter | eq | | &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;|
     * operationId | filter | eq | | &lt;/br&gt;| callCountSuccess | select | | | &lt;/br&gt;| callCountBlocked | select
     * | | | &lt;/br&gt;| callCountFailed | select | | | &lt;/br&gt;| callCountOther | select | | | &lt;/br&gt;|
     * bandwidth | select, orderBy | | | &lt;/br&gt;| cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select
     * | | | &lt;/br&gt;| apiTimeAvg | select | | | &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax |
     * select | | | &lt;/br&gt;| serviceTimeAvg | select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;|
     * serviceTimeMax | select | | | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listByGeoSinglePageAsync(String resourceGroupName,
        String serviceName, String filter, Integer top, Integer skip) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error(new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByGeo(this.client.getEndpoint(), resourceGroupName, serviceName, filter,
                top, skip, this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .<PagedResponse<ReportRecordContractInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists report records by geography.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| country | select | | | &lt;/br&gt;| region | select | | | &lt;/br&gt;| zip | select | | |
     * &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId | filter | eq | | &lt;/br&gt;| productId | filter |
     * eq | | &lt;/br&gt;| subscriptionId | filter | eq | | &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;|
     * operationId | filter | eq | | &lt;/br&gt;| callCountSuccess | select | | | &lt;/br&gt;| callCountBlocked | select
     * | | | &lt;/br&gt;| callCountFailed | select | | | &lt;/br&gt;| callCountOther | select | | | &lt;/br&gt;|
     * bandwidth | select, orderBy | | | &lt;/br&gt;| cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select
     * | | | &lt;/br&gt;| apiTimeAvg | select | | | &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax |
     * select | | | &lt;/br&gt;| serviceTimeAvg | select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;|
     * serviceTimeMax | select | | | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listByGeoSinglePageAsync(String resourceGroupName,
        String serviceName, String filter, Integer top, Integer skip, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error(new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByGeo(this.client.getEndpoint(), resourceGroupName, serviceName, filter, top, skip,
                this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists report records by geography.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| country | select | | | &lt;/br&gt;| region | select | | | &lt;/br&gt;| zip | select | | |
     * &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId | filter | eq | | &lt;/br&gt;| productId | filter |
     * eq | | &lt;/br&gt;| subscriptionId | filter | eq | | &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;|
     * operationId | filter | eq | | &lt;/br&gt;| callCountSuccess | select | | | &lt;/br&gt;| callCountBlocked | select
     * | | | &lt;/br&gt;| callCountFailed | select | | | &lt;/br&gt;| callCountOther | select | | | &lt;/br&gt;|
     * bandwidth | select, orderBy | | | &lt;/br&gt;| cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select
     * | | | &lt;/br&gt;| apiTimeAvg | select | | | &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax |
     * select | | | &lt;/br&gt;| serviceTimeAvg | select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;|
     * serviceTimeMax | select | | | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ReportRecordContractInner> listByGeoAsync(String resourceGroupName, String serviceName,
        String filter, Integer top, Integer skip) {
        return new PagedFlux<>(() -> listByGeoSinglePageAsync(resourceGroupName, serviceName, filter, top, skip),
            nextLink -> listByGeoNextSinglePageAsync(nextLink));
    }

    /**
     * Lists report records by geography.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| country | select | | | &lt;/br&gt;| region | select | | | &lt;/br&gt;| zip | select | | |
     * &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId | filter | eq | | &lt;/br&gt;| productId | filter |
     * eq | | &lt;/br&gt;| subscriptionId | filter | eq | | &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;|
     * operationId | filter | eq | | &lt;/br&gt;| callCountSuccess | select | | | &lt;/br&gt;| callCountBlocked | select
     * | | | &lt;/br&gt;| callCountFailed | select | | | &lt;/br&gt;| callCountOther | select | | | &lt;/br&gt;|
     * bandwidth | select, orderBy | | | &lt;/br&gt;| cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select
     * | | | &lt;/br&gt;| apiTimeAvg | select | | | &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax |
     * select | | | &lt;/br&gt;| serviceTimeAvg | select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;|
     * serviceTimeMax | select | | | &lt;/br&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ReportRecordContractInner> listByGeoAsync(String resourceGroupName, String serviceName,
        String filter) {
        final Integer top = null;
        final Integer skip = null;
        return new PagedFlux<>(() -> listByGeoSinglePageAsync(resourceGroupName, serviceName, filter, top, skip),
            nextLink -> listByGeoNextSinglePageAsync(nextLink));
    }

    /**
     * Lists report records by geography.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| country | select | | | &lt;/br&gt;| region | select | | | &lt;/br&gt;| zip | select | | |
     * &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId | filter | eq | | &lt;/br&gt;| productId | filter |
     * eq | | &lt;/br&gt;| subscriptionId | filter | eq | | &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;|
     * operationId | filter | eq | | &lt;/br&gt;| callCountSuccess | select | | | &lt;/br&gt;| callCountBlocked | select
     * | | | &lt;/br&gt;| callCountFailed | select | | | &lt;/br&gt;| callCountOther | select | | | &lt;/br&gt;|
     * bandwidth | select, orderBy | | | &lt;/br&gt;| cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select
     * | | | &lt;/br&gt;| apiTimeAvg | select | | | &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax |
     * select | | | &lt;/br&gt;| serviceTimeAvg | select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;|
     * serviceTimeMax | select | | | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ReportRecordContractInner> listByGeoAsync(String resourceGroupName, String serviceName,
        String filter, Integer top, Integer skip, Context context) {
        return new PagedFlux<>(
            () -> listByGeoSinglePageAsync(resourceGroupName, serviceName, filter, top, skip, context),
            nextLink -> listByGeoNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists report records by geography.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| country | select | | | &lt;/br&gt;| region | select | | | &lt;/br&gt;| zip | select | | |
     * &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId | filter | eq | | &lt;/br&gt;| productId | filter |
     * eq | | &lt;/br&gt;| subscriptionId | filter | eq | | &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;|
     * operationId | filter | eq | | &lt;/br&gt;| callCountSuccess | select | | | &lt;/br&gt;| callCountBlocked | select
     * | | | &lt;/br&gt;| callCountFailed | select | | | &lt;/br&gt;| callCountOther | select | | | &lt;/br&gt;|
     * bandwidth | select, orderBy | | | &lt;/br&gt;| cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select
     * | | | &lt;/br&gt;| apiTimeAvg | select | | | &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax |
     * select | | | &lt;/br&gt;| serviceTimeAvg | select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;|
     * serviceTimeMax | select | | | &lt;/br&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ReportRecordContractInner> listByGeo(String resourceGroupName, String serviceName,
        String filter) {
        final Integer top = null;
        final Integer skip = null;
        return new PagedIterable<>(listByGeoAsync(resourceGroupName, serviceName, filter, top, skip));
    }

    /**
     * Lists report records by geography.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| country | select | | | &lt;/br&gt;| region | select | | | &lt;/br&gt;| zip | select | | |
     * &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId | filter | eq | | &lt;/br&gt;| productId | filter |
     * eq | | &lt;/br&gt;| subscriptionId | filter | eq | | &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;|
     * operationId | filter | eq | | &lt;/br&gt;| callCountSuccess | select | | | &lt;/br&gt;| callCountBlocked | select
     * | | | &lt;/br&gt;| callCountFailed | select | | | &lt;/br&gt;| callCountOther | select | | | &lt;/br&gt;|
     * bandwidth | select, orderBy | | | &lt;/br&gt;| cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select
     * | | | &lt;/br&gt;| apiTimeAvg | select | | | &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax |
     * select | | | &lt;/br&gt;| serviceTimeAvg | select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;|
     * serviceTimeMax | select | | | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ReportRecordContractInner> listByGeo(String resourceGroupName, String serviceName,
        String filter, Integer top, Integer skip, Context context) {
        return new PagedIterable<>(listByGeoAsync(resourceGroupName, serviceName, filter, top, skip, context));
    }

    /**
     * Lists report records by subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * select, filter | eq | | &lt;/br&gt;| productId | select, filter | eq | | &lt;/br&gt;| subscriptionId | select,
     * filter | eq | | &lt;/br&gt;| callCountSuccess | select, orderBy | | | &lt;/br&gt;| callCountBlocked | select,
     * orderBy | | | &lt;/br&gt;| callCountFailed | select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy
     * | | | &lt;/br&gt;| callCountTotal | select, orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | |
     * &lt;/br&gt;| cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg |
     * select, orderBy | | | &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;|
     * serviceTimeAvg | select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | |
     * | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listBySubscriptionSinglePageAsync(String resourceGroupName,
        String serviceName, String filter, Integer top, Integer skip, String orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error(new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listBySubscription(this.client.getEndpoint(), resourceGroupName, serviceName, filter,
                    top, skip, orderby, this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .<PagedResponse<ReportRecordContractInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists report records by subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * select, filter | eq | | &lt;/br&gt;| productId | select, filter | eq | | &lt;/br&gt;| subscriptionId | select,
     * filter | eq | | &lt;/br&gt;| callCountSuccess | select, orderBy | | | &lt;/br&gt;| callCountBlocked | select,
     * orderBy | | | &lt;/br&gt;| callCountFailed | select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy
     * | | | &lt;/br&gt;| callCountTotal | select, orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | |
     * &lt;/br&gt;| cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg |
     * select, orderBy | | | &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;|
     * serviceTimeAvg | select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | |
     * | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listBySubscriptionSinglePageAsync(String resourceGroupName,
        String serviceName, String filter, Integer top, Integer skip, String orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error(new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listBySubscription(this.client.getEndpoint(), resourceGroupName, serviceName, filter, top, skip, orderby,
                this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists report records by subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * select, filter | eq | | &lt;/br&gt;| productId | select, filter | eq | | &lt;/br&gt;| subscriptionId | select,
     * filter | eq | | &lt;/br&gt;| callCountSuccess | select, orderBy | | | &lt;/br&gt;| callCountBlocked | select,
     * orderBy | | | &lt;/br&gt;| callCountFailed | select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy
     * | | | &lt;/br&gt;| callCountTotal | select, orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | |
     * &lt;/br&gt;| cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg |
     * select, orderBy | | | &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;|
     * serviceTimeAvg | select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | |
     * | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ReportRecordContractInner> listBySubscriptionAsync(String resourceGroupName, String serviceName,
        String filter, Integer top, Integer skip, String orderby) {
        return new PagedFlux<>(
            () -> listBySubscriptionSinglePageAsync(resourceGroupName, serviceName, filter, top, skip, orderby),
            nextLink -> listBySubscriptionNextSinglePageAsync(nextLink));
    }

    /**
     * Lists report records by subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * select, filter | eq | | &lt;/br&gt;| productId | select, filter | eq | | &lt;/br&gt;| subscriptionId | select,
     * filter | eq | | &lt;/br&gt;| callCountSuccess | select, orderBy | | | &lt;/br&gt;| callCountBlocked | select,
     * orderBy | | | &lt;/br&gt;| callCountFailed | select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy
     * | | | &lt;/br&gt;| callCountTotal | select, orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | |
     * &lt;/br&gt;| cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg |
     * select, orderBy | | | &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;|
     * serviceTimeAvg | select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | |
     * | &lt;/br&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ReportRecordContractInner> listBySubscriptionAsync(String resourceGroupName, String serviceName,
        String filter) {
        final Integer top = null;
        final Integer skip = null;
        final String orderby = null;
        return new PagedFlux<>(
            () -> listBySubscriptionSinglePageAsync(resourceGroupName, serviceName, filter, top, skip, orderby),
            nextLink -> listBySubscriptionNextSinglePageAsync(nextLink));
    }

    /**
     * Lists report records by subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * select, filter | eq | | &lt;/br&gt;| productId | select, filter | eq | | &lt;/br&gt;| subscriptionId | select,
     * filter | eq | | &lt;/br&gt;| callCountSuccess | select, orderBy | | | &lt;/br&gt;| callCountBlocked | select,
     * orderBy | | | &lt;/br&gt;| callCountFailed | select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy
     * | | | &lt;/br&gt;| callCountTotal | select, orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | |
     * &lt;/br&gt;| cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg |
     * select, orderBy | | | &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;|
     * serviceTimeAvg | select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | |
     * | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ReportRecordContractInner> listBySubscriptionAsync(String resourceGroupName, String serviceName,
        String filter, Integer top, Integer skip, String orderby, Context context) {
        return new PagedFlux<>(() -> listBySubscriptionSinglePageAsync(resourceGroupName, serviceName, filter, top,
            skip, orderby, context), nextLink -> listBySubscriptionNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists report records by subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * select, filter | eq | | &lt;/br&gt;| productId | select, filter | eq | | &lt;/br&gt;| subscriptionId | select,
     * filter | eq | | &lt;/br&gt;| callCountSuccess | select, orderBy | | | &lt;/br&gt;| callCountBlocked | select,
     * orderBy | | | &lt;/br&gt;| callCountFailed | select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy
     * | | | &lt;/br&gt;| callCountTotal | select, orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | |
     * &lt;/br&gt;| cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg |
     * select, orderBy | | | &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;|
     * serviceTimeAvg | select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | |
     * | &lt;/br&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ReportRecordContractInner> listBySubscription(String resourceGroupName, String serviceName,
        String filter) {
        final Integer top = null;
        final Integer skip = null;
        final String orderby = null;
        return new PagedIterable<>(listBySubscriptionAsync(resourceGroupName, serviceName, filter, top, skip, orderby));
    }

    /**
     * Lists report records by subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| displayName | select, orderBy | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * select, filter | eq | | &lt;/br&gt;| productId | select, filter | eq | | &lt;/br&gt;| subscriptionId | select,
     * filter | eq | | &lt;/br&gt;| callCountSuccess | select, orderBy | | | &lt;/br&gt;| callCountBlocked | select,
     * orderBy | | | &lt;/br&gt;| callCountFailed | select, orderBy | | | &lt;/br&gt;| callCountOther | select, orderBy
     * | | | &lt;/br&gt;| callCountTotal | select, orderBy | | | &lt;/br&gt;| bandwidth | select, orderBy | | |
     * &lt;/br&gt;| cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg |
     * select, orderBy | | | &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;|
     * serviceTimeAvg | select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | |
     * | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ReportRecordContractInner> listBySubscription(String resourceGroupName, String serviceName,
        String filter, Integer top, Integer skip, String orderby, Context context) {
        return new PagedIterable<>(
            listBySubscriptionAsync(resourceGroupName, serviceName, filter, top, skip, orderby, context));
    }

    /**
     * Lists report records by Time.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter, select |
     * ge, le | | &lt;/br&gt;| interval | select | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * filter | eq | | &lt;/br&gt;| productId | filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq | |
     * &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | filter | eq | | &lt;/br&gt;| callCountSuccess |
     * select | | | &lt;/br&gt;| callCountBlocked | select | | | &lt;/br&gt;| callCountFailed | select | | |
     * &lt;/br&gt;| callCountOther | select | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;|
     * cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select | | |
     * &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;| serviceTimeAvg |
     * select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | | | &lt;/br&gt;.
     * @param interval By time interval. Interval must be multiple of 15 minutes and may not be zero. The value should
     * be in ISO 8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert TimeSpan
     * to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes, seconds)).
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listByTimeSinglePageAsync(String resourceGroupName,
        String serviceName, String filter, Duration interval, Integer top, Integer skip, String orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error(new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        if (interval == null) {
            return Mono.error(new IllegalArgumentException("Parameter interval is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByTime(this.client.getEndpoint(), resourceGroupName, serviceName,
                filter, top, skip, orderby, interval, this.client.getApiVersion(), this.client.getSubscriptionId(),
                accept, context))
            .<PagedResponse<ReportRecordContractInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists report records by Time.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter, select |
     * ge, le | | &lt;/br&gt;| interval | select | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * filter | eq | | &lt;/br&gt;| productId | filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq | |
     * &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | filter | eq | | &lt;/br&gt;| callCountSuccess |
     * select | | | &lt;/br&gt;| callCountBlocked | select | | | &lt;/br&gt;| callCountFailed | select | | |
     * &lt;/br&gt;| callCountOther | select | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;|
     * cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select | | |
     * &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;| serviceTimeAvg |
     * select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | | | &lt;/br&gt;.
     * @param interval By time interval. Interval must be multiple of 15 minutes and may not be zero. The value should
     * be in ISO 8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert TimeSpan
     * to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes, seconds)).
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listByTimeSinglePageAsync(String resourceGroupName,
        String serviceName, String filter, Duration interval, Integer top, Integer skip, String orderby,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error(new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        if (interval == null) {
            return Mono.error(new IllegalArgumentException("Parameter interval is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByTime(this.client.getEndpoint(), resourceGroupName, serviceName, filter, top, skip, orderby, interval,
                this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists report records by Time.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter, select |
     * ge, le | | &lt;/br&gt;| interval | select | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * filter | eq | | &lt;/br&gt;| productId | filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq | |
     * &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | filter | eq | | &lt;/br&gt;| callCountSuccess |
     * select | | | &lt;/br&gt;| callCountBlocked | select | | | &lt;/br&gt;| callCountFailed | select | | |
     * &lt;/br&gt;| callCountOther | select | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;|
     * cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select | | |
     * &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;| serviceTimeAvg |
     * select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | | | &lt;/br&gt;.
     * @param interval By time interval. Interval must be multiple of 15 minutes and may not be zero. The value should
     * be in ISO 8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert TimeSpan
     * to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes, seconds)).
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ReportRecordContractInner> listByTimeAsync(String resourceGroupName, String serviceName,
        String filter, Duration interval, Integer top, Integer skip, String orderby) {
        return new PagedFlux<>(
            () -> listByTimeSinglePageAsync(resourceGroupName, serviceName, filter, interval, top, skip, orderby),
            nextLink -> listByTimeNextSinglePageAsync(nextLink));
    }

    /**
     * Lists report records by Time.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter, select |
     * ge, le | | &lt;/br&gt;| interval | select | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * filter | eq | | &lt;/br&gt;| productId | filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq | |
     * &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | filter | eq | | &lt;/br&gt;| callCountSuccess |
     * select | | | &lt;/br&gt;| callCountBlocked | select | | | &lt;/br&gt;| callCountFailed | select | | |
     * &lt;/br&gt;| callCountOther | select | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;|
     * cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select | | |
     * &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;| serviceTimeAvg |
     * select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | | | &lt;/br&gt;.
     * @param interval By time interval. Interval must be multiple of 15 minutes and may not be zero. The value should
     * be in ISO 8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert TimeSpan
     * to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes, seconds)).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ReportRecordContractInner> listByTimeAsync(String resourceGroupName, String serviceName,
        String filter, Duration interval) {
        final Integer top = null;
        final Integer skip = null;
        final String orderby = null;
        return new PagedFlux<>(
            () -> listByTimeSinglePageAsync(resourceGroupName, serviceName, filter, interval, top, skip, orderby),
            nextLink -> listByTimeNextSinglePageAsync(nextLink));
    }

    /**
     * Lists report records by Time.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter, select |
     * ge, le | | &lt;/br&gt;| interval | select | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * filter | eq | | &lt;/br&gt;| productId | filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq | |
     * &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | filter | eq | | &lt;/br&gt;| callCountSuccess |
     * select | | | &lt;/br&gt;| callCountBlocked | select | | | &lt;/br&gt;| callCountFailed | select | | |
     * &lt;/br&gt;| callCountOther | select | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;|
     * cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select | | |
     * &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;| serviceTimeAvg |
     * select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | | | &lt;/br&gt;.
     * @param interval By time interval. Interval must be multiple of 15 minutes and may not be zero. The value should
     * be in ISO 8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert TimeSpan
     * to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes, seconds)).
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ReportRecordContractInner> listByTimeAsync(String resourceGroupName, String serviceName,
        String filter, Duration interval, Integer top, Integer skip, String orderby, Context context) {
        return new PagedFlux<>(() -> listByTimeSinglePageAsync(resourceGroupName, serviceName, filter, interval, top,
            skip, orderby, context), nextLink -> listByTimeNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists report records by Time.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter, select |
     * ge, le | | &lt;/br&gt;| interval | select | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * filter | eq | | &lt;/br&gt;| productId | filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq | |
     * &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | filter | eq | | &lt;/br&gt;| callCountSuccess |
     * select | | | &lt;/br&gt;| callCountBlocked | select | | | &lt;/br&gt;| callCountFailed | select | | |
     * &lt;/br&gt;| callCountOther | select | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;|
     * cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select | | |
     * &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;| serviceTimeAvg |
     * select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | | | &lt;/br&gt;.
     * @param interval By time interval. Interval must be multiple of 15 minutes and may not be zero. The value should
     * be in ISO 8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert TimeSpan
     * to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes, seconds)).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ReportRecordContractInner> listByTime(String resourceGroupName, String serviceName,
        String filter, Duration interval) {
        final Integer top = null;
        final Integer skip = null;
        final String orderby = null;
        return new PagedIterable<>(
            listByTimeAsync(resourceGroupName, serviceName, filter, interval, top, skip, orderby));
    }

    /**
     * Lists report records by Time.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter, select |
     * ge, le | | &lt;/br&gt;| interval | select | | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| userId |
     * filter | eq | | &lt;/br&gt;| productId | filter | eq | | &lt;/br&gt;| subscriptionId | filter | eq | |
     * &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | filter | eq | | &lt;/br&gt;| callCountSuccess |
     * select | | | &lt;/br&gt;| callCountBlocked | select | | | &lt;/br&gt;| callCountFailed | select | | |
     * &lt;/br&gt;| callCountOther | select | | | &lt;/br&gt;| bandwidth | select, orderBy | | | &lt;/br&gt;|
     * cacheHitsCount | select | | | &lt;/br&gt;| cacheMissCount | select | | | &lt;/br&gt;| apiTimeAvg | select | | |
     * &lt;/br&gt;| apiTimeMin | select | | | &lt;/br&gt;| apiTimeMax | select | | | &lt;/br&gt;| serviceTimeAvg |
     * select | | | &lt;/br&gt;| serviceTimeMin | select | | | &lt;/br&gt;| serviceTimeMax | select | | | &lt;/br&gt;.
     * @param interval By time interval. Interval must be multiple of 15 minutes and may not be zero. The value should
     * be in ISO 8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert TimeSpan
     * to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes, seconds)).
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param orderby OData order by query option.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ReportRecordContractInner> listByTime(String resourceGroupName, String serviceName,
        String filter, Duration interval, Integer top, Integer skip, String orderby, Context context) {
        return new PagedIterable<>(
            listByTimeAsync(resourceGroupName, serviceName, filter, interval, top, skip, orderby, context));
    }

    /**
     * Lists report records by Request.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | filter | eq | | &lt;/br&gt;| productId | filter |
     * eq | | &lt;/br&gt;| userId | filter | eq | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| subscriptionId
     * | filter | eq | | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RequestReportRecordContractInner>> listByRequestSinglePageAsync(String resourceGroupName,
        String serviceName, String filter, Integer top, Integer skip) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error(new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByRequest(this.client.getEndpoint(), resourceGroupName, serviceName,
                filter, top, skip, this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .<PagedResponse<RequestReportRecordContractInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists report records by Request.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | filter | eq | | &lt;/br&gt;| productId | filter |
     * eq | | &lt;/br&gt;| userId | filter | eq | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| subscriptionId
     * | filter | eq | | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RequestReportRecordContractInner>> listByRequestSinglePageAsync(String resourceGroupName,
        String serviceName, String filter, Integer top, Integer skip, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error(new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByRequest(this.client.getEndpoint(), resourceGroupName, serviceName, filter, top, skip,
                this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), null, null));
    }

    /**
     * Lists report records by Request.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | filter | eq | | &lt;/br&gt;| productId | filter |
     * eq | | &lt;/br&gt;| userId | filter | eq | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| subscriptionId
     * | filter | eq | | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<RequestReportRecordContractInner> listByRequestAsync(String resourceGroupName, String serviceName,
        String filter, Integer top, Integer skip) {
        return new PagedFlux<>(() -> listByRequestSinglePageAsync(resourceGroupName, serviceName, filter, top, skip));
    }

    /**
     * Lists report records by Request.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | filter | eq | | &lt;/br&gt;| productId | filter |
     * eq | | &lt;/br&gt;| userId | filter | eq | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| subscriptionId
     * | filter | eq | | &lt;/br&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<RequestReportRecordContractInner> listByRequestAsync(String resourceGroupName, String serviceName,
        String filter) {
        final Integer top = null;
        final Integer skip = null;
        return new PagedFlux<>(() -> listByRequestSinglePageAsync(resourceGroupName, serviceName, filter, top, skip));
    }

    /**
     * Lists report records by Request.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | filter | eq | | &lt;/br&gt;| productId | filter |
     * eq | | &lt;/br&gt;| userId | filter | eq | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| subscriptionId
     * | filter | eq | | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<RequestReportRecordContractInner> listByRequestAsync(String resourceGroupName, String serviceName,
        String filter, Integer top, Integer skip, Context context) {
        return new PagedFlux<>(
            () -> listByRequestSinglePageAsync(resourceGroupName, serviceName, filter, top, skip, context));
    }

    /**
     * Lists report records by Request.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | filter | eq | | &lt;/br&gt;| productId | filter |
     * eq | | &lt;/br&gt;| userId | filter | eq | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| subscriptionId
     * | filter | eq | | &lt;/br&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RequestReportRecordContractInner> listByRequest(String resourceGroupName, String serviceName,
        String filter) {
        final Integer top = null;
        final Integer skip = null;
        return new PagedIterable<>(listByRequestAsync(resourceGroupName, serviceName, filter, top, skip));
    }

    /**
     * Lists report records by Request.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| timestamp | filter | ge, le | |
     * &lt;/br&gt;| apiId | filter | eq | | &lt;/br&gt;| operationId | filter | eq | | &lt;/br&gt;| productId | filter |
     * eq | | &lt;/br&gt;| userId | filter | eq | | &lt;/br&gt;| apiRegion | filter | eq | | &lt;/br&gt;| subscriptionId
     * | filter | eq | | &lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RequestReportRecordContractInner> listByRequest(String resourceGroupName, String serviceName,
        String filter, Integer top, Integer skip, Context context) {
        return new PagedIterable<>(listByRequestAsync(resourceGroupName, serviceName, filter, top, skip, context));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listByApiNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByApiNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<ReportRecordContractInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listByApiNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByApiNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listByUserNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByUserNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<ReportRecordContractInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listByUserNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByUserNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listByOperationNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByOperationNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<ReportRecordContractInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listByOperationNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByOperationNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listByProductNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByProductNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<ReportRecordContractInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listByProductNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByProductNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listByGeoNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByGeoNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<ReportRecordContractInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listByGeoNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByGeoNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<ReportRecordContractInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listBySubscriptionNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listByTimeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByTimeNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<ReportRecordContractInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Report records list representation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReportRecordContractInner>> listByTimeNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByTimeNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
