// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.ResolverContractInner;
import com.azure.resourcemanager.apimanagement.models.ResolverContract;
import com.azure.resourcemanager.apimanagement.models.ResolverUpdateContract;

public final class ResolverContractImpl
    implements ResolverContract, ResolverContract.Definition, ResolverContract.Update {
    private ResolverContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String displayName() {
        return this.innerModel().displayName();
    }

    public String path() {
        return this.innerModel().path();
    }

    public String description() {
        return this.innerModel().description();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public ResolverContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String apiId;

    private String resolverId;

    private String createIfMatch;

    private String updateIfMatch;

    private ResolverUpdateContract updateParameters;

    public ResolverContractImpl withExistingApi(String resourceGroupName, String serviceName, String apiId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.apiId = apiId;
        return this;
    }

    public ResolverContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getGraphQLApiResolvers()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, apiId, resolverId, this.innerModel(),
                createIfMatch, Context.NONE)
            .getValue();
        return this;
    }

    public ResolverContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getGraphQLApiResolvers()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, apiId, resolverId, this.innerModel(),
                createIfMatch, context)
            .getValue();
        return this;
    }

    ResolverContractImpl(String name, com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new ResolverContractInner();
        this.serviceManager = serviceManager;
        this.resolverId = name;
        this.createIfMatch = null;
    }

    public ResolverContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new ResolverUpdateContract();
        return this;
    }

    public ResolverContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getGraphQLApiResolvers()
            .updateWithResponse(resourceGroupName, serviceName, apiId, resolverId, updateIfMatch, updateParameters,
                Context.NONE)
            .getValue();
        return this;
    }

    public ResolverContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getGraphQLApiResolvers()
            .updateWithResponse(resourceGroupName, serviceName, apiId, resolverId, updateIfMatch, updateParameters,
                context)
            .getValue();
        return this;
    }

    ResolverContractImpl(ResolverContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.apiId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apis");
        this.resolverId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resolvers");
    }

    public ResolverContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getGraphQLApiResolvers()
            .getWithResponse(resourceGroupName, serviceName, apiId, resolverId, Context.NONE)
            .getValue();
        return this;
    }

    public ResolverContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getGraphQLApiResolvers()
            .getWithResponse(resourceGroupName, serviceName, apiId, resolverId, context)
            .getValue();
        return this;
    }

    public ResolverContractImpl withDisplayName(String displayName) {
        if (isInCreateMode()) {
            this.innerModel().withDisplayName(displayName);
            return this;
        } else {
            this.updateParameters.withDisplayName(displayName);
            return this;
        }
    }

    public ResolverContractImpl withPath(String path) {
        if (isInCreateMode()) {
            this.innerModel().withPath(path);
            return this;
        } else {
            this.updateParameters.withPath(path);
            return this;
        }
    }

    public ResolverContractImpl withDescription(String description) {
        if (isInCreateMode()) {
            this.innerModel().withDescription(description);
            return this;
        } else {
            this.updateParameters.withDescription(description);
            return this;
        }
    }

    public ResolverContractImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
