// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.apimanagement.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ConnectivityCheckResponseInner;
import com.azure.resourcemanager.apimanagement.models.ConnectivityCheckRequest;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in ResourceProvidersClient.
 */
public final class ResourceProvidersClientImpl implements ResourceProvidersClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final ResourceProvidersService service;

    /**
     * The service client containing this operation class.
     */
    private final ApiManagementClientImpl client;

    /**
     * Initializes an instance of ResourceProvidersClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    ResourceProvidersClientImpl(ApiManagementClientImpl client) {
        this.service
            = RestProxy.create(ResourceProvidersService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ApiManagementClientResourceProviders to be used by the proxy service
     * to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ApiManagementClientR")
    public interface ResourceProvidersService {
        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/connectivityCheck")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> performConnectivityCheckAsync(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serviceName") String serviceName,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") ConnectivityCheckRequest connectivityCheckRequestParams,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Performs a connectivity check between the API Management service and a given destination, and returns metrics for
     * the connection, as well as errors encountered while trying to establish it.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param connectivityCheckRequestParams Connectivity Check request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the connectivity status along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> performConnectivityCheckAsyncWithResponseAsync(String resourceGroupName,
        String serviceName, ConnectivityCheckRequest connectivityCheckRequestParams) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (connectivityCheckRequestParams == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter connectivityCheckRequestParams is required and cannot be null."));
        } else {
            connectivityCheckRequestParams.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.performConnectivityCheckAsync(this.client.getEndpoint(), resourceGroupName,
                serviceName, this.client.getApiVersion(), this.client.getSubscriptionId(),
                connectivityCheckRequestParams, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Performs a connectivity check between the API Management service and a given destination, and returns metrics for
     * the connection, as well as errors encountered while trying to establish it.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param connectivityCheckRequestParams Connectivity Check request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the connectivity status along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> performConnectivityCheckAsyncWithResponseAsync(String resourceGroupName,
        String serviceName, ConnectivityCheckRequest connectivityCheckRequestParams, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (connectivityCheckRequestParams == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter connectivityCheckRequestParams is required and cannot be null."));
        } else {
            connectivityCheckRequestParams.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.performConnectivityCheckAsync(this.client.getEndpoint(), resourceGroupName, serviceName,
            this.client.getApiVersion(), this.client.getSubscriptionId(), connectivityCheckRequestParams, accept,
            context);
    }

    /**
     * Performs a connectivity check between the API Management service and a given destination, and returns metrics for
     * the connection, as well as errors encountered while trying to establish it.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param connectivityCheckRequestParams Connectivity Check request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of information on the connectivity status.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ConnectivityCheckResponseInner>, ConnectivityCheckResponseInner>
        beginPerformConnectivityCheckAsyncAsync(String resourceGroupName, String serviceName,
            ConnectivityCheckRequest connectivityCheckRequestParams) {
        Mono<Response<Flux<ByteBuffer>>> mono = performConnectivityCheckAsyncWithResponseAsync(resourceGroupName,
            serviceName, connectivityCheckRequestParams);
        return this.client.<ConnectivityCheckResponseInner, ConnectivityCheckResponseInner>getLroResult(mono,
            this.client.getHttpPipeline(), ConnectivityCheckResponseInner.class, ConnectivityCheckResponseInner.class,
            this.client.getContext());
    }

    /**
     * Performs a connectivity check between the API Management service and a given destination, and returns metrics for
     * the connection, as well as errors encountered while trying to establish it.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param connectivityCheckRequestParams Connectivity Check request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of information on the connectivity status.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ConnectivityCheckResponseInner>, ConnectivityCheckResponseInner>
        beginPerformConnectivityCheckAsyncAsync(String resourceGroupName, String serviceName,
            ConnectivityCheckRequest connectivityCheckRequestParams, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = performConnectivityCheckAsyncWithResponseAsync(resourceGroupName,
            serviceName, connectivityCheckRequestParams, context);
        return this.client.<ConnectivityCheckResponseInner, ConnectivityCheckResponseInner>getLroResult(mono,
            this.client.getHttpPipeline(), ConnectivityCheckResponseInner.class, ConnectivityCheckResponseInner.class,
            context);
    }

    /**
     * Performs a connectivity check between the API Management service and a given destination, and returns metrics for
     * the connection, as well as errors encountered while trying to establish it.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param connectivityCheckRequestParams Connectivity Check request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information on the connectivity status.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConnectivityCheckResponseInner>, ConnectivityCheckResponseInner>
        beginPerformConnectivityCheckAsync(String resourceGroupName, String serviceName,
            ConnectivityCheckRequest connectivityCheckRequestParams) {
        return this
            .beginPerformConnectivityCheckAsyncAsync(resourceGroupName, serviceName, connectivityCheckRequestParams)
            .getSyncPoller();
    }

    /**
     * Performs a connectivity check between the API Management service and a given destination, and returns metrics for
     * the connection, as well as errors encountered while trying to establish it.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param connectivityCheckRequestParams Connectivity Check request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information on the connectivity status.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConnectivityCheckResponseInner>, ConnectivityCheckResponseInner>
        beginPerformConnectivityCheckAsync(String resourceGroupName, String serviceName,
            ConnectivityCheckRequest connectivityCheckRequestParams, Context context) {
        return this
            .beginPerformConnectivityCheckAsyncAsync(resourceGroupName, serviceName, connectivityCheckRequestParams,
                context)
            .getSyncPoller();
    }

    /**
     * Performs a connectivity check between the API Management service and a given destination, and returns metrics for
     * the connection, as well as errors encountered while trying to establish it.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param connectivityCheckRequestParams Connectivity Check request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the connectivity status on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ConnectivityCheckResponseInner> performConnectivityCheckAsyncAsync(String resourceGroupName,
        String serviceName, ConnectivityCheckRequest connectivityCheckRequestParams) {
        return beginPerformConnectivityCheckAsyncAsync(resourceGroupName, serviceName, connectivityCheckRequestParams)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Performs a connectivity check between the API Management service and a given destination, and returns metrics for
     * the connection, as well as errors encountered while trying to establish it.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param connectivityCheckRequestParams Connectivity Check request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the connectivity status on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ConnectivityCheckResponseInner> performConnectivityCheckAsyncAsync(String resourceGroupName,
        String serviceName, ConnectivityCheckRequest connectivityCheckRequestParams, Context context) {
        return beginPerformConnectivityCheckAsyncAsync(resourceGroupName, serviceName, connectivityCheckRequestParams,
            context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Performs a connectivity check between the API Management service and a given destination, and returns metrics for
     * the connection, as well as errors encountered while trying to establish it.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param connectivityCheckRequestParams Connectivity Check request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the connectivity status.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ConnectivityCheckResponseInner performConnectivityCheckAsync(String resourceGroupName, String serviceName,
        ConnectivityCheckRequest connectivityCheckRequestParams) {
        return performConnectivityCheckAsyncAsync(resourceGroupName, serviceName, connectivityCheckRequestParams)
            .block();
    }

    /**
     * Performs a connectivity check between the API Management service and a given destination, and returns metrics for
     * the connection, as well as errors encountered while trying to establish it.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param connectivityCheckRequestParams Connectivity Check request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the connectivity status.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ConnectivityCheckResponseInner performConnectivityCheckAsync(String resourceGroupName, String serviceName,
        ConnectivityCheckRequest connectivityCheckRequestParams, Context context) {
        return performConnectivityCheckAsyncAsync(resourceGroupName, serviceName, connectivityCheckRequestParams,
            context).block();
    }
}
