// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.SignInSettingsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.PortalSigninSettingsInner;
import com.azure.resourcemanager.apimanagement.models.PortalSigninSettings;
import com.azure.resourcemanager.apimanagement.models.SignInSettings;
import com.azure.resourcemanager.apimanagement.models.SignInSettingsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.SignInSettingsGetResponse;

public final class SignInSettingsImpl implements SignInSettings {
    private static final ClientLogger LOGGER = new ClientLogger(SignInSettingsImpl.class);

    private final SignInSettingsClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public SignInSettingsImpl(SignInSettingsClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public SignInSettingsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName);
    }

    public Response<PortalSigninSettings> getWithResponse(String resourceGroupName, String serviceName,
        Context context) {
        SignInSettingsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new PortalSigninSettingsImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public PortalSigninSettings get(String resourceGroupName, String serviceName) {
        PortalSigninSettingsInner inner = this.serviceClient().get(resourceGroupName, serviceName);
        if (inner != null) {
            return new PortalSigninSettingsImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> updateWithResponse(String resourceGroupName, String serviceName, String ifMatch,
        PortalSigninSettingsInner parameters, Context context) {
        return this.serviceClient().updateWithResponse(resourceGroupName, serviceName, ifMatch, parameters, context);
    }

    public void update(String resourceGroupName, String serviceName, String ifMatch,
        PortalSigninSettingsInner parameters) {
        this.serviceClient().update(resourceGroupName, serviceName, ifMatch, parameters);
    }

    public Response<PortalSigninSettings> createOrUpdateWithResponse(String resourceGroupName, String serviceName,
        PortalSigninSettingsInner parameters, String ifMatch, Context context) {
        Response<PortalSigninSettingsInner> inner = this.serviceClient()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, parameters, ifMatch, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new PortalSigninSettingsImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public PortalSigninSettings createOrUpdate(String resourceGroupName, String serviceName,
        PortalSigninSettingsInner parameters) {
        PortalSigninSettingsInner inner
            = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, parameters);
        if (inner != null) {
            return new PortalSigninSettingsImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private SignInSettingsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
