// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.SignUpSettingsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.PortalSignupSettingsInner;
import com.azure.resourcemanager.apimanagement.models.PortalSignupSettings;
import com.azure.resourcemanager.apimanagement.models.SignUpSettings;
import com.azure.resourcemanager.apimanagement.models.SignUpSettingsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.SignUpSettingsGetResponse;

public final class SignUpSettingsImpl implements SignUpSettings {
    private static final ClientLogger LOGGER = new ClientLogger(SignUpSettingsImpl.class);

    private final SignUpSettingsClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public SignUpSettingsImpl(SignUpSettingsClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public SignUpSettingsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName);
    }

    public Response<PortalSignupSettings> getWithResponse(String resourceGroupName, String serviceName,
        Context context) {
        SignUpSettingsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new PortalSignupSettingsImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public PortalSignupSettings get(String resourceGroupName, String serviceName) {
        PortalSignupSettingsInner inner = this.serviceClient().get(resourceGroupName, serviceName);
        if (inner != null) {
            return new PortalSignupSettingsImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> updateWithResponse(String resourceGroupName, String serviceName, String ifMatch,
        PortalSignupSettingsInner parameters, Context context) {
        return this.serviceClient().updateWithResponse(resourceGroupName, serviceName, ifMatch, parameters, context);
    }

    public void update(String resourceGroupName, String serviceName, String ifMatch,
        PortalSignupSettingsInner parameters) {
        this.serviceClient().update(resourceGroupName, serviceName, ifMatch, parameters);
    }

    public Response<PortalSignupSettings> createOrUpdateWithResponse(String resourceGroupName, String serviceName,
        PortalSignupSettingsInner parameters, String ifMatch, Context context) {
        Response<PortalSignupSettingsInner> inner = this.serviceClient()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, parameters, ifMatch, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new PortalSignupSettingsImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public PortalSignupSettings createOrUpdate(String resourceGroupName, String serviceName,
        PortalSignupSettingsInner parameters) {
        PortalSignupSettingsInner inner
            = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, parameters);
        if (inner != null) {
            return new PortalSignupSettingsImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private SignUpSettingsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
