// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.TagApiLinkContractInner;
import com.azure.resourcemanager.apimanagement.models.TagApiLinkContract;

public final class TagApiLinkContractImpl
    implements TagApiLinkContract, TagApiLinkContract.Definition, TagApiLinkContract.Update {
    private TagApiLinkContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String apiId() {
        return this.innerModel().apiId();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public TagApiLinkContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String tagId;

    private String apiLinkId;

    public TagApiLinkContractImpl withExistingTag(String resourceGroupName, String serviceName, String tagId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.tagId = tagId;
        return this;
    }

    public TagApiLinkContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getTagApiLinks()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, tagId, apiLinkId, this.innerModel(),
                Context.NONE)
            .getValue();
        return this;
    }

    public TagApiLinkContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getTagApiLinks()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, tagId, apiLinkId, this.innerModel(), context)
            .getValue();
        return this;
    }

    TagApiLinkContractImpl(String name, com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new TagApiLinkContractInner();
        this.serviceManager = serviceManager;
        this.apiLinkId = name;
    }

    public TagApiLinkContractImpl update() {
        return this;
    }

    public TagApiLinkContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getTagApiLinks()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, tagId, apiLinkId, this.innerModel(),
                Context.NONE)
            .getValue();
        return this;
    }

    public TagApiLinkContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getTagApiLinks()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, tagId, apiLinkId, this.innerModel(), context)
            .getValue();
        return this;
    }

    TagApiLinkContractImpl(TagApiLinkContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.tagId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "tags");
        this.apiLinkId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apiLinks");
    }

    public TagApiLinkContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getTagApiLinks()
            .getWithResponse(resourceGroupName, serviceName, tagId, apiLinkId, Context.NONE)
            .getValue();
        return this;
    }

    public TagApiLinkContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getTagApiLinks()
            .getWithResponse(resourceGroupName, serviceName, tagId, apiLinkId, context)
            .getValue();
        return this;
    }

    public TagApiLinkContractImpl withApiId(String apiId) {
        this.innerModel().withApiId(apiId);
        return this;
    }
}
