// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.TagOperationLinkContractInner;
import com.azure.resourcemanager.apimanagement.models.TagOperationLinkContract;

public final class TagOperationLinkContractImpl
    implements TagOperationLinkContract, TagOperationLinkContract.Definition, TagOperationLinkContract.Update {
    private TagOperationLinkContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String operationId() {
        return this.innerModel().operationId();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public TagOperationLinkContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String tagId;

    private String operationLinkId;

    public TagOperationLinkContractImpl withExistingTag(String resourceGroupName, String serviceName, String tagId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.tagId = tagId;
        return this;
    }

    public TagOperationLinkContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getTagOperationLinks()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, tagId, operationLinkId, this.innerModel(),
                Context.NONE)
            .getValue();
        return this;
    }

    public TagOperationLinkContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getTagOperationLinks()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, tagId, operationLinkId, this.innerModel(),
                context)
            .getValue();
        return this;
    }

    TagOperationLinkContractImpl(String name,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new TagOperationLinkContractInner();
        this.serviceManager = serviceManager;
        this.operationLinkId = name;
    }

    public TagOperationLinkContractImpl update() {
        return this;
    }

    public TagOperationLinkContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getTagOperationLinks()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, tagId, operationLinkId, this.innerModel(),
                Context.NONE)
            .getValue();
        return this;
    }

    public TagOperationLinkContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getTagOperationLinks()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, tagId, operationLinkId, this.innerModel(),
                context)
            .getValue();
        return this;
    }

    TagOperationLinkContractImpl(TagOperationLinkContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.tagId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "tags");
        this.operationLinkId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "operationLinks");
    }

    public TagOperationLinkContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getTagOperationLinks()
            .getWithResponse(resourceGroupName, serviceName, tagId, operationLinkId, Context.NONE)
            .getValue();
        return this;
    }

    public TagOperationLinkContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getTagOperationLinks()
            .getWithResponse(resourceGroupName, serviceName, tagId, operationLinkId, context)
            .getValue();
        return this;
    }

    public TagOperationLinkContractImpl withOperationId(String operationId) {
        this.innerModel().withOperationId(operationId);
        return this;
    }
}
