// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.TagOperationLinksClient;
import com.azure.resourcemanager.apimanagement.fluent.models.TagOperationLinkContractInner;
import com.azure.resourcemanager.apimanagement.models.TagOperationLinkContract;
import com.azure.resourcemanager.apimanagement.models.TagOperationLinks;
import com.azure.resourcemanager.apimanagement.models.TagOperationLinksGetResponse;

public final class TagOperationLinksImpl implements TagOperationLinks {
    private static final ClientLogger LOGGER = new ClientLogger(TagOperationLinksImpl.class);

    private final TagOperationLinksClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public TagOperationLinksImpl(TagOperationLinksClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<TagOperationLinkContract> listByProduct(String resourceGroupName, String serviceName,
        String tagId) {
        PagedIterable<TagOperationLinkContractInner> inner
            = this.serviceClient().listByProduct(resourceGroupName, serviceName, tagId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagOperationLinkContractImpl(inner1, this.manager()));
    }

    public PagedIterable<TagOperationLinkContract> listByProduct(String resourceGroupName, String serviceName,
        String tagId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<TagOperationLinkContractInner> inner
            = this.serviceClient().listByProduct(resourceGroupName, serviceName, tagId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagOperationLinkContractImpl(inner1, this.manager()));
    }

    public Response<TagOperationLinkContract> getWithResponse(String resourceGroupName, String serviceName,
        String tagId, String operationLinkId, Context context) {
        TagOperationLinksGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, tagId, operationLinkId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new TagOperationLinkContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public TagOperationLinkContract get(String resourceGroupName, String serviceName, String tagId,
        String operationLinkId) {
        TagOperationLinkContractInner inner
            = this.serviceClient().get(resourceGroupName, serviceName, tagId, operationLinkId);
        if (inner != null) {
            return new TagOperationLinkContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String tagId,
        String operationLinkId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, tagId, operationLinkId, context);
    }

    public void delete(String resourceGroupName, String serviceName, String tagId, String operationLinkId) {
        this.serviceClient().delete(resourceGroupName, serviceName, tagId, operationLinkId);
    }

    public TagOperationLinkContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String tagId = ResourceManagerUtils.getValueFromIdByName(id, "tags");
        if (tagId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'tags'.", id)));
        }
        String operationLinkId = ResourceManagerUtils.getValueFromIdByName(id, "operationLinks");
        if (operationLinkId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'operationLinks'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, tagId, operationLinkId, Context.NONE).getValue();
    }

    public Response<TagOperationLinkContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String tagId = ResourceManagerUtils.getValueFromIdByName(id, "tags");
        if (tagId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'tags'.", id)));
        }
        String operationLinkId = ResourceManagerUtils.getValueFromIdByName(id, "operationLinks");
        if (operationLinkId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'operationLinks'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, tagId, operationLinkId, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String tagId = ResourceManagerUtils.getValueFromIdByName(id, "tags");
        if (tagId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'tags'.", id)));
        }
        String operationLinkId = ResourceManagerUtils.getValueFromIdByName(id, "operationLinks");
        if (operationLinkId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'operationLinks'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, serviceName, tagId, operationLinkId, Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String tagId = ResourceManagerUtils.getValueFromIdByName(id, "tags");
        if (tagId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'tags'.", id)));
        }
        String operationLinkId = ResourceManagerUtils.getValueFromIdByName(id, "operationLinks");
        if (operationLinkId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'operationLinks'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, tagId, operationLinkId, context);
    }

    private TagOperationLinksClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    public TagOperationLinkContractImpl define(String name) {
        return new TagOperationLinkContractImpl(name, this.manager());
    }
}
