// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.TagProductLinksClient;
import com.azure.resourcemanager.apimanagement.fluent.models.TagProductLinkContractInner;
import com.azure.resourcemanager.apimanagement.models.TagProductLinkContract;
import com.azure.resourcemanager.apimanagement.models.TagProductLinks;
import com.azure.resourcemanager.apimanagement.models.TagProductLinksGetResponse;

public final class TagProductLinksImpl implements TagProductLinks {
    private static final ClientLogger LOGGER = new ClientLogger(TagProductLinksImpl.class);

    private final TagProductLinksClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public TagProductLinksImpl(TagProductLinksClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<TagProductLinkContract> listByProduct(String resourceGroupName, String serviceName,
        String tagId) {
        PagedIterable<TagProductLinkContractInner> inner
            = this.serviceClient().listByProduct(resourceGroupName, serviceName, tagId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagProductLinkContractImpl(inner1, this.manager()));
    }

    public PagedIterable<TagProductLinkContract> listByProduct(String resourceGroupName, String serviceName,
        String tagId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<TagProductLinkContractInner> inner
            = this.serviceClient().listByProduct(resourceGroupName, serviceName, tagId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagProductLinkContractImpl(inner1, this.manager()));
    }

    public Response<TagProductLinkContract> getWithResponse(String resourceGroupName, String serviceName, String tagId,
        String productLinkId, Context context) {
        TagProductLinksGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, tagId, productLinkId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new TagProductLinkContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public TagProductLinkContract get(String resourceGroupName, String serviceName, String tagId,
        String productLinkId) {
        TagProductLinkContractInner inner
            = this.serviceClient().get(resourceGroupName, serviceName, tagId, productLinkId);
        if (inner != null) {
            return new TagProductLinkContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String tagId,
        String productLinkId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, tagId, productLinkId, context);
    }

    public void delete(String resourceGroupName, String serviceName, String tagId, String productLinkId) {
        this.serviceClient().delete(resourceGroupName, serviceName, tagId, productLinkId);
    }

    public TagProductLinkContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String tagId = ResourceManagerUtils.getValueFromIdByName(id, "tags");
        if (tagId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'tags'.", id)));
        }
        String productLinkId = ResourceManagerUtils.getValueFromIdByName(id, "productLinks");
        if (productLinkId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'productLinks'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, tagId, productLinkId, Context.NONE).getValue();
    }

    public Response<TagProductLinkContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String tagId = ResourceManagerUtils.getValueFromIdByName(id, "tags");
        if (tagId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'tags'.", id)));
        }
        String productLinkId = ResourceManagerUtils.getValueFromIdByName(id, "productLinks");
        if (productLinkId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'productLinks'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, tagId, productLinkId, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String tagId = ResourceManagerUtils.getValueFromIdByName(id, "tags");
        if (tagId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'tags'.", id)));
        }
        String productLinkId = ResourceManagerUtils.getValueFromIdByName(id, "productLinks");
        if (productLinkId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'productLinks'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, serviceName, tagId, productLinkId, Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String tagId = ResourceManagerUtils.getValueFromIdByName(id, "tags");
        if (tagId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'tags'.", id)));
        }
        String productLinkId = ResourceManagerUtils.getValueFromIdByName(id, "productLinks");
        if (productLinkId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'productLinks'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, tagId, productLinkId, context);
    }

    private TagProductLinksClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    public TagProductLinkContractImpl define(String name) {
        return new TagProductLinkContractImpl(name, this.manager());
    }
}
