// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.TenantAccessGitsClient;
import com.azure.resourcemanager.apimanagement.models.AccessIdName;
import com.azure.resourcemanager.apimanagement.models.TenantAccessGits;

public final class TenantAccessGitsImpl implements TenantAccessGits {
    private static final ClientLogger LOGGER = new ClientLogger(TenantAccessGitsImpl.class);

    private final TenantAccessGitsClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public TenantAccessGitsImpl(TenantAccessGitsClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<Void> regeneratePrimaryKeyWithResponse(String resourceGroupName, String serviceName,
        AccessIdName accessName, Context context) {
        return this.serviceClient()
            .regeneratePrimaryKeyWithResponse(resourceGroupName, serviceName, accessName, context);
    }

    public void regeneratePrimaryKey(String resourceGroupName, String serviceName, AccessIdName accessName) {
        this.serviceClient().regeneratePrimaryKey(resourceGroupName, serviceName, accessName);
    }

    public Response<Void> regenerateSecondaryKeyWithResponse(String resourceGroupName, String serviceName,
        AccessIdName accessName, Context context) {
        return this.serviceClient()
            .regenerateSecondaryKeyWithResponse(resourceGroupName, serviceName, accessName, context);
    }

    public void regenerateSecondaryKey(String resourceGroupName, String serviceName, AccessIdName accessName) {
        this.serviceClient().regenerateSecondaryKey(resourceGroupName, serviceName, accessName);
    }

    private TenantAccessGitsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
