// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.apimanagement.fluent.TenantConfigurationsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.OperationResultContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.TenantConfigurationSyncStateContractInner;
import com.azure.resourcemanager.apimanagement.models.ConfigurationIdName;
import com.azure.resourcemanager.apimanagement.models.DeployConfigurationParameters;
import com.azure.resourcemanager.apimanagement.models.SaveConfigurationParameter;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in TenantConfigurationsClient.
 */
public final class TenantConfigurationsClientImpl implements TenantConfigurationsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final TenantConfigurationsService service;

    /**
     * The service client containing this operation class.
     */
    private final ApiManagementClientImpl client;

    /**
     * Initializes an instance of TenantConfigurationsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    TenantConfigurationsClientImpl(ApiManagementClientImpl client) {
        this.service = RestProxy.create(TenantConfigurationsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ApiManagementClientTenantConfigurations to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ApiManagementClientT")
    public interface TenantConfigurationsService {
        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/{configurationName}/deploy")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> deploy(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serviceName") String serviceName,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("configurationName") ConfigurationIdName configurationName,
            @BodyParam("application/json") DeployConfigurationParameters parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/{configurationName}/save")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> save(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serviceName") String serviceName,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("configurationName") ConfigurationIdName configurationName,
            @BodyParam("application/json") SaveConfigurationParameter parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/{configurationName}/validate")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> validate(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serviceName") String serviceName,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("configurationName") ConfigurationIdName configurationName,
            @BodyParam("application/json") DeployConfigurationParameters parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/{configurationName}/syncState")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<TenantConfigurationSyncStateContractInner>> getSyncState(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serviceName") String serviceName,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("configurationName") ConfigurationIdName configurationName, @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * This operation applies changes from the specified Git branch to the configuration database. This is a long
     * running operation and could take several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Deploy Configuration parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return long Running Git Operation Results along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deployWithResponseAsync(String resourceGroupName, String serviceName,
        ConfigurationIdName configurationName, DeployConfigurationParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.deploy(this.client.getEndpoint(), resourceGroupName, serviceName,
                this.client.getApiVersion(), this.client.getSubscriptionId(), configurationName, parameters, accept,
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * This operation applies changes from the specified Git branch to the configuration database. This is a long
     * running operation and could take several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Deploy Configuration parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return long Running Git Operation Results along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deployWithResponseAsync(String resourceGroupName, String serviceName,
        ConfigurationIdName configurationName, DeployConfigurationParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deploy(this.client.getEndpoint(), resourceGroupName, serviceName, this.client.getApiVersion(),
            this.client.getSubscriptionId(), configurationName, parameters, accept, context);
    }

    /**
     * This operation applies changes from the specified Git branch to the configuration database. This is a long
     * running operation and could take several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Deploy Configuration parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long Running Git Operation Results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationResultContractInner>, OperationResultContractInner> beginDeployAsync(
        String resourceGroupName, String serviceName, ConfigurationIdName configurationName,
        DeployConfigurationParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deployWithResponseAsync(resourceGroupName, serviceName, configurationName, parameters);
        return this.client.<OperationResultContractInner, OperationResultContractInner>getLroResult(mono,
            this.client.getHttpPipeline(), OperationResultContractInner.class, OperationResultContractInner.class,
            this.client.getContext());
    }

    /**
     * This operation applies changes from the specified Git branch to the configuration database. This is a long
     * running operation and could take several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Deploy Configuration parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long Running Git Operation Results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationResultContractInner>, OperationResultContractInner> beginDeployAsync(
        String resourceGroupName, String serviceName, ConfigurationIdName configurationName,
        DeployConfigurationParameters parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deployWithResponseAsync(resourceGroupName, serviceName, configurationName, parameters, context);
        return this.client.<OperationResultContractInner, OperationResultContractInner>getLroResult(mono,
            this.client.getHttpPipeline(), OperationResultContractInner.class, OperationResultContractInner.class,
            context);
    }

    /**
     * This operation applies changes from the specified Git branch to the configuration database. This is a long
     * running operation and could take several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Deploy Configuration parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long Running Git Operation Results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationResultContractInner>, OperationResultContractInner> beginDeploy(
        String resourceGroupName, String serviceName, ConfigurationIdName configurationName,
        DeployConfigurationParameters parameters) {
        return this.beginDeployAsync(resourceGroupName, serviceName, configurationName, parameters).getSyncPoller();
    }

    /**
     * This operation applies changes from the specified Git branch to the configuration database. This is a long
     * running operation and could take several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Deploy Configuration parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long Running Git Operation Results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationResultContractInner>, OperationResultContractInner> beginDeploy(
        String resourceGroupName, String serviceName, ConfigurationIdName configurationName,
        DeployConfigurationParameters parameters, Context context) {
        return this.beginDeployAsync(resourceGroupName, serviceName, configurationName, parameters, context)
            .getSyncPoller();
    }

    /**
     * This operation applies changes from the specified Git branch to the configuration database. This is a long
     * running operation and could take several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Deploy Configuration parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return long Running Git Operation Results on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<OperationResultContractInner> deployAsync(String resourceGroupName, String serviceName,
        ConfigurationIdName configurationName, DeployConfigurationParameters parameters) {
        return beginDeployAsync(resourceGroupName, serviceName, configurationName, parameters).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * This operation applies changes from the specified Git branch to the configuration database. This is a long
     * running operation and could take several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Deploy Configuration parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return long Running Git Operation Results on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<OperationResultContractInner> deployAsync(String resourceGroupName, String serviceName,
        ConfigurationIdName configurationName, DeployConfigurationParameters parameters, Context context) {
        return beginDeployAsync(resourceGroupName, serviceName, configurationName, parameters, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * This operation applies changes from the specified Git branch to the configuration database. This is a long
     * running operation and could take several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Deploy Configuration parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return long Running Git Operation Results.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public OperationResultContractInner deploy(String resourceGroupName, String serviceName,
        ConfigurationIdName configurationName, DeployConfigurationParameters parameters) {
        return deployAsync(resourceGroupName, serviceName, configurationName, parameters).block();
    }

    /**
     * This operation applies changes from the specified Git branch to the configuration database. This is a long
     * running operation and could take several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Deploy Configuration parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return long Running Git Operation Results.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public OperationResultContractInner deploy(String resourceGroupName, String serviceName,
        ConfigurationIdName configurationName, DeployConfigurationParameters parameters, Context context) {
        return deployAsync(resourceGroupName, serviceName, configurationName, parameters, context).block();
    }

    /**
     * This operation creates a commit with the current configuration snapshot to the specified branch in the
     * repository. This is a long running operation and could take several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Save Configuration parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return long Running Git Operation Results along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> saveWithResponseAsync(String resourceGroupName, String serviceName,
        ConfigurationIdName configurationName, SaveConfigurationParameter parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.save(this.client.getEndpoint(), resourceGroupName, serviceName,
                this.client.getApiVersion(), this.client.getSubscriptionId(), configurationName, parameters, accept,
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * This operation creates a commit with the current configuration snapshot to the specified branch in the
     * repository. This is a long running operation and could take several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Save Configuration parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return long Running Git Operation Results along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> saveWithResponseAsync(String resourceGroupName, String serviceName,
        ConfigurationIdName configurationName, SaveConfigurationParameter parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.save(this.client.getEndpoint(), resourceGroupName, serviceName, this.client.getApiVersion(),
            this.client.getSubscriptionId(), configurationName, parameters, accept, context);
    }

    /**
     * This operation creates a commit with the current configuration snapshot to the specified branch in the
     * repository. This is a long running operation and could take several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Save Configuration parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long Running Git Operation Results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationResultContractInner>, OperationResultContractInner> beginSaveAsync(
        String resourceGroupName, String serviceName, ConfigurationIdName configurationName,
        SaveConfigurationParameter parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = saveWithResponseAsync(resourceGroupName, serviceName, configurationName, parameters);
        return this.client.<OperationResultContractInner, OperationResultContractInner>getLroResult(mono,
            this.client.getHttpPipeline(), OperationResultContractInner.class, OperationResultContractInner.class,
            this.client.getContext());
    }

    /**
     * This operation creates a commit with the current configuration snapshot to the specified branch in the
     * repository. This is a long running operation and could take several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Save Configuration parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long Running Git Operation Results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationResultContractInner>, OperationResultContractInner> beginSaveAsync(
        String resourceGroupName, String serviceName, ConfigurationIdName configurationName,
        SaveConfigurationParameter parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = saveWithResponseAsync(resourceGroupName, serviceName, configurationName, parameters, context);
        return this.client.<OperationResultContractInner, OperationResultContractInner>getLroResult(mono,
            this.client.getHttpPipeline(), OperationResultContractInner.class, OperationResultContractInner.class,
            context);
    }

    /**
     * This operation creates a commit with the current configuration snapshot to the specified branch in the
     * repository. This is a long running operation and could take several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Save Configuration parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long Running Git Operation Results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationResultContractInner>, OperationResultContractInner> beginSave(
        String resourceGroupName, String serviceName, ConfigurationIdName configurationName,
        SaveConfigurationParameter parameters) {
        return this.beginSaveAsync(resourceGroupName, serviceName, configurationName, parameters).getSyncPoller();
    }

    /**
     * This operation creates a commit with the current configuration snapshot to the specified branch in the
     * repository. This is a long running operation and could take several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Save Configuration parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long Running Git Operation Results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationResultContractInner>, OperationResultContractInner> beginSave(
        String resourceGroupName, String serviceName, ConfigurationIdName configurationName,
        SaveConfigurationParameter parameters, Context context) {
        return this.beginSaveAsync(resourceGroupName, serviceName, configurationName, parameters, context)
            .getSyncPoller();
    }

    /**
     * This operation creates a commit with the current configuration snapshot to the specified branch in the
     * repository. This is a long running operation and could take several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Save Configuration parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return long Running Git Operation Results on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<OperationResultContractInner> saveAsync(String resourceGroupName, String serviceName,
        ConfigurationIdName configurationName, SaveConfigurationParameter parameters) {
        return beginSaveAsync(resourceGroupName, serviceName, configurationName, parameters).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * This operation creates a commit with the current configuration snapshot to the specified branch in the
     * repository. This is a long running operation and could take several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Save Configuration parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return long Running Git Operation Results on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<OperationResultContractInner> saveAsync(String resourceGroupName, String serviceName,
        ConfigurationIdName configurationName, SaveConfigurationParameter parameters, Context context) {
        return beginSaveAsync(resourceGroupName, serviceName, configurationName, parameters, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * This operation creates a commit with the current configuration snapshot to the specified branch in the
     * repository. This is a long running operation and could take several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Save Configuration parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return long Running Git Operation Results.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public OperationResultContractInner save(String resourceGroupName, String serviceName,
        ConfigurationIdName configurationName, SaveConfigurationParameter parameters) {
        return saveAsync(resourceGroupName, serviceName, configurationName, parameters).block();
    }

    /**
     * This operation creates a commit with the current configuration snapshot to the specified branch in the
     * repository. This is a long running operation and could take several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Save Configuration parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return long Running Git Operation Results.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public OperationResultContractInner save(String resourceGroupName, String serviceName,
        ConfigurationIdName configurationName, SaveConfigurationParameter parameters, Context context) {
        return saveAsync(resourceGroupName, serviceName, configurationName, parameters, context).block();
    }

    /**
     * This operation validates the changes in the specified Git branch. This is a long running operation and could take
     * several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Validate Configuration parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return long Running Git Operation Results along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateWithResponseAsync(String resourceGroupName, String serviceName,
        ConfigurationIdName configurationName, DeployConfigurationParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.validate(this.client.getEndpoint(), resourceGroupName, serviceName,
                this.client.getApiVersion(), this.client.getSubscriptionId(), configurationName, parameters, accept,
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * This operation validates the changes in the specified Git branch. This is a long running operation and could take
     * several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Validate Configuration parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return long Running Git Operation Results along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateWithResponseAsync(String resourceGroupName, String serviceName,
        ConfigurationIdName configurationName, DeployConfigurationParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.validate(this.client.getEndpoint(), resourceGroupName, serviceName, this.client.getApiVersion(),
            this.client.getSubscriptionId(), configurationName, parameters, accept, context);
    }

    /**
     * This operation validates the changes in the specified Git branch. This is a long running operation and could take
     * several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Validate Configuration parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long Running Git Operation Results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationResultContractInner>, OperationResultContractInner> beginValidateAsync(
        String resourceGroupName, String serviceName, ConfigurationIdName configurationName,
        DeployConfigurationParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = validateWithResponseAsync(resourceGroupName, serviceName, configurationName, parameters);
        return this.client.<OperationResultContractInner, OperationResultContractInner>getLroResult(mono,
            this.client.getHttpPipeline(), OperationResultContractInner.class, OperationResultContractInner.class,
            this.client.getContext());
    }

    /**
     * This operation validates the changes in the specified Git branch. This is a long running operation and could take
     * several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Validate Configuration parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long Running Git Operation Results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationResultContractInner>, OperationResultContractInner> beginValidateAsync(
        String resourceGroupName, String serviceName, ConfigurationIdName configurationName,
        DeployConfigurationParameters parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = validateWithResponseAsync(resourceGroupName, serviceName, configurationName, parameters, context);
        return this.client.<OperationResultContractInner, OperationResultContractInner>getLroResult(mono,
            this.client.getHttpPipeline(), OperationResultContractInner.class, OperationResultContractInner.class,
            context);
    }

    /**
     * This operation validates the changes in the specified Git branch. This is a long running operation and could take
     * several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Validate Configuration parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long Running Git Operation Results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationResultContractInner>, OperationResultContractInner> beginValidate(
        String resourceGroupName, String serviceName, ConfigurationIdName configurationName,
        DeployConfigurationParameters parameters) {
        return this.beginValidateAsync(resourceGroupName, serviceName, configurationName, parameters).getSyncPoller();
    }

    /**
     * This operation validates the changes in the specified Git branch. This is a long running operation and could take
     * several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Validate Configuration parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long Running Git Operation Results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationResultContractInner>, OperationResultContractInner> beginValidate(
        String resourceGroupName, String serviceName, ConfigurationIdName configurationName,
        DeployConfigurationParameters parameters, Context context) {
        return this.beginValidateAsync(resourceGroupName, serviceName, configurationName, parameters, context)
            .getSyncPoller();
    }

    /**
     * This operation validates the changes in the specified Git branch. This is a long running operation and could take
     * several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Validate Configuration parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return long Running Git Operation Results on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<OperationResultContractInner> validateAsync(String resourceGroupName, String serviceName,
        ConfigurationIdName configurationName, DeployConfigurationParameters parameters) {
        return beginValidateAsync(resourceGroupName, serviceName, configurationName, parameters).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * This operation validates the changes in the specified Git branch. This is a long running operation and could take
     * several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Validate Configuration parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return long Running Git Operation Results on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<OperationResultContractInner> validateAsync(String resourceGroupName, String serviceName,
        ConfigurationIdName configurationName, DeployConfigurationParameters parameters, Context context) {
        return beginValidateAsync(resourceGroupName, serviceName, configurationName, parameters, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * This operation validates the changes in the specified Git branch. This is a long running operation and could take
     * several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Validate Configuration parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return long Running Git Operation Results.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public OperationResultContractInner validate(String resourceGroupName, String serviceName,
        ConfigurationIdName configurationName, DeployConfigurationParameters parameters) {
        return validateAsync(resourceGroupName, serviceName, configurationName, parameters).block();
    }

    /**
     * This operation validates the changes in the specified Git branch. This is a long running operation and could take
     * several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param parameters Validate Configuration parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return long Running Git Operation Results.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public OperationResultContractInner validate(String resourceGroupName, String serviceName,
        ConfigurationIdName configurationName, DeployConfigurationParameters parameters, Context context) {
        return validateAsync(resourceGroupName, serviceName, configurationName, parameters, context).block();
    }

    /**
     * Gets the status of the most recent synchronization between the configuration database and the Git repository.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the status of the most recent synchronization between the configuration database and the Git repository
     * along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<TenantConfigurationSyncStateContractInner>> getSyncStateWithResponseAsync(
        String resourceGroupName, String serviceName, ConfigurationIdName configurationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getSyncState(this.client.getEndpoint(), resourceGroupName, serviceName,
                this.client.getApiVersion(), this.client.getSubscriptionId(), configurationName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the status of the most recent synchronization between the configuration database and the Git repository.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the status of the most recent synchronization between the configuration database and the Git repository
     * along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<TenantConfigurationSyncStateContractInner>> getSyncStateWithResponseAsync(
        String resourceGroupName, String serviceName, ConfigurationIdName configurationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getSyncState(this.client.getEndpoint(), resourceGroupName, serviceName,
            this.client.getApiVersion(), this.client.getSubscriptionId(), configurationName, accept, context);
    }

    /**
     * Gets the status of the most recent synchronization between the configuration database and the Git repository.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the status of the most recent synchronization between the configuration database and the Git repository
     * on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<TenantConfigurationSyncStateContractInner> getSyncStateAsync(String resourceGroupName,
        String serviceName, ConfigurationIdName configurationName) {
        return getSyncStateWithResponseAsync(resourceGroupName, serviceName, configurationName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the status of the most recent synchronization between the configuration database and the Git repository.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the status of the most recent synchronization between the configuration database and the Git repository
     * along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<TenantConfigurationSyncStateContractInner> getSyncStateWithResponse(String resourceGroupName,
        String serviceName, ConfigurationIdName configurationName, Context context) {
        return getSyncStateWithResponseAsync(resourceGroupName, serviceName, configurationName, context).block();
    }

    /**
     * Gets the status of the most recent synchronization between the configuration database and the Git repository.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param configurationName The identifier of the Git Configuration Operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the status of the most recent synchronization between the configuration database and the Git repository.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public TenantConfigurationSyncStateContractInner getSyncState(String resourceGroupName, String serviceName,
        ConfigurationIdName configurationName) {
        return getSyncStateWithResponse(resourceGroupName, serviceName, configurationName, Context.NONE).getValue();
    }
}
