// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.TenantConfigurationsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.OperationResultContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.TenantConfigurationSyncStateContractInner;
import com.azure.resourcemanager.apimanagement.models.ConfigurationIdName;
import com.azure.resourcemanager.apimanagement.models.DeployConfigurationParameters;
import com.azure.resourcemanager.apimanagement.models.OperationResultContract;
import com.azure.resourcemanager.apimanagement.models.SaveConfigurationParameter;
import com.azure.resourcemanager.apimanagement.models.TenantConfigurationSyncStateContract;
import com.azure.resourcemanager.apimanagement.models.TenantConfigurations;

public final class TenantConfigurationsImpl implements TenantConfigurations {
    private static final ClientLogger LOGGER = new ClientLogger(TenantConfigurationsImpl.class);

    private final TenantConfigurationsClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public TenantConfigurationsImpl(TenantConfigurationsClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public OperationResultContract deploy(String resourceGroupName, String serviceName,
        ConfigurationIdName configurationName, DeployConfigurationParameters parameters) {
        OperationResultContractInner inner
            = this.serviceClient().deploy(resourceGroupName, serviceName, configurationName, parameters);
        if (inner != null) {
            return new OperationResultContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public OperationResultContract deploy(String resourceGroupName, String serviceName,
        ConfigurationIdName configurationName, DeployConfigurationParameters parameters, Context context) {
        OperationResultContractInner inner
            = this.serviceClient().deploy(resourceGroupName, serviceName, configurationName, parameters, context);
        if (inner != null) {
            return new OperationResultContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public OperationResultContract save(String resourceGroupName, String serviceName,
        ConfigurationIdName configurationName, SaveConfigurationParameter parameters) {
        OperationResultContractInner inner
            = this.serviceClient().save(resourceGroupName, serviceName, configurationName, parameters);
        if (inner != null) {
            return new OperationResultContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public OperationResultContract save(String resourceGroupName, String serviceName,
        ConfigurationIdName configurationName, SaveConfigurationParameter parameters, Context context) {
        OperationResultContractInner inner
            = this.serviceClient().save(resourceGroupName, serviceName, configurationName, parameters, context);
        if (inner != null) {
            return new OperationResultContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public OperationResultContract validate(String resourceGroupName, String serviceName,
        ConfigurationIdName configurationName, DeployConfigurationParameters parameters) {
        OperationResultContractInner inner
            = this.serviceClient().validate(resourceGroupName, serviceName, configurationName, parameters);
        if (inner != null) {
            return new OperationResultContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public OperationResultContract validate(String resourceGroupName, String serviceName,
        ConfigurationIdName configurationName, DeployConfigurationParameters parameters, Context context) {
        OperationResultContractInner inner
            = this.serviceClient().validate(resourceGroupName, serviceName, configurationName, parameters, context);
        if (inner != null) {
            return new OperationResultContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<TenantConfigurationSyncStateContract> getSyncStateWithResponse(String resourceGroupName,
        String serviceName, ConfigurationIdName configurationName, Context context) {
        Response<TenantConfigurationSyncStateContractInner> inner
            = this.serviceClient().getSyncStateWithResponse(resourceGroupName, serviceName, configurationName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new TenantConfigurationSyncStateContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public TenantConfigurationSyncStateContract getSyncState(String resourceGroupName, String serviceName,
        ConfigurationIdName configurationName) {
        TenantConfigurationSyncStateContractInner inner
            = this.serviceClient().getSyncState(resourceGroupName, serviceName, configurationName);
        if (inner != null) {
            return new TenantConfigurationSyncStateContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private TenantConfigurationsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
