// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.UserConfirmationPasswordsClient;
import com.azure.resourcemanager.apimanagement.models.AppType;
import com.azure.resourcemanager.apimanagement.models.UserConfirmationPasswords;

public final class UserConfirmationPasswordsImpl implements UserConfirmationPasswords {
    private static final ClientLogger LOGGER = new ClientLogger(UserConfirmationPasswordsImpl.class);

    private final UserConfirmationPasswordsClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public UserConfirmationPasswordsImpl(UserConfirmationPasswordsClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<Void> sendWithResponse(String resourceGroupName, String serviceName, String userId, AppType appType,
        Context context) {
        return this.serviceClient().sendWithResponse(resourceGroupName, serviceName, userId, appType, context);
    }

    public void send(String resourceGroupName, String serviceName, String userId) {
        this.serviceClient().send(resourceGroupName, serviceName, userId);
    }

    private UserConfirmationPasswordsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
