// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceApiOperationsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.OperationContractInner;
import com.azure.resourcemanager.apimanagement.models.OperationContract;
import com.azure.resourcemanager.apimanagement.models.OperationUpdateContract;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiOperations;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiOperationsCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiOperationsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiOperationsGetResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiOperationsUpdateResponse;

public final class WorkspaceApiOperationsImpl implements WorkspaceApiOperations {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceApiOperationsImpl.class);

    private final WorkspaceApiOperationsClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public WorkspaceApiOperationsImpl(WorkspaceApiOperationsClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<OperationContract> listByApi(String resourceGroupName, String serviceName, String workspaceId,
        String apiId) {
        PagedIterable<OperationContractInner> inner
            = this.serviceClient().listByApi(resourceGroupName, serviceName, workspaceId, apiId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OperationContractImpl(inner1, this.manager()));
    }

    public PagedIterable<OperationContract> listByApi(String resourceGroupName, String serviceName, String workspaceId,
        String apiId, String filter, Integer top, Integer skip, String tags, Context context) {
        PagedIterable<OperationContractInner> inner = this.serviceClient()
            .listByApi(resourceGroupName, serviceName, workspaceId, apiId, filter, top, skip, tags, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OperationContractImpl(inner1, this.manager()));
    }

    public WorkspaceApiOperationsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName,
        String serviceName, String workspaceId, String apiId, String operationId, Context context) {
        return this.serviceClient()
            .getEntityTagWithResponse(resourceGroupName, serviceName, workspaceId, apiId, operationId, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String workspaceId, String apiId,
        String operationId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, workspaceId, apiId, operationId);
    }

    public Response<OperationContract> getWithResponse(String resourceGroupName, String serviceName, String workspaceId,
        String apiId, String operationId, Context context) {
        WorkspaceApiOperationsGetResponse inner = this.serviceClient()
            .getWithResponse(resourceGroupName, serviceName, workspaceId, apiId, operationId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new OperationContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public OperationContract get(String resourceGroupName, String serviceName, String workspaceId, String apiId,
        String operationId) {
        OperationContractInner inner
            = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, apiId, operationId);
        if (inner != null) {
            return new OperationContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<OperationContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, String apiId, String operationId, OperationContractInner parameters, String ifMatch,
        Context context) {
        WorkspaceApiOperationsCreateOrUpdateResponse inner = this.serviceClient()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, apiId, operationId, parameters,
                ifMatch, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new OperationContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public OperationContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId,
        String apiId, String operationId, OperationContractInner parameters) {
        OperationContractInner inner = this.serviceClient()
            .createOrUpdate(resourceGroupName, serviceName, workspaceId, apiId, operationId, parameters);
        if (inner != null) {
            return new OperationContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<OperationContract> updateWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, String apiId, String operationId, String ifMatch, OperationUpdateContract parameters,
        Context context) {
        WorkspaceApiOperationsUpdateResponse inner = this.serviceClient()
            .updateWithResponse(resourceGroupName, serviceName, workspaceId, apiId, operationId, ifMatch, parameters,
                context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new OperationContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public OperationContract update(String resourceGroupName, String serviceName, String workspaceId, String apiId,
        String operationId, String ifMatch, OperationUpdateContract parameters) {
        OperationContractInner inner = this.serviceClient()
            .update(resourceGroupName, serviceName, workspaceId, apiId, operationId, ifMatch, parameters);
        if (inner != null) {
            return new OperationContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId,
        String apiId, String operationId, String ifMatch, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, serviceName, workspaceId, apiId, operationId, ifMatch, context);
    }

    public void delete(String resourceGroupName, String serviceName, String workspaceId, String apiId,
        String operationId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, apiId, operationId, ifMatch);
    }

    private WorkspaceApiOperationsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
