// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceApiPoliciesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyContractInner;
import com.azure.resourcemanager.apimanagement.models.PolicyContract;
import com.azure.resourcemanager.apimanagement.models.PolicyExportFormat;
import com.azure.resourcemanager.apimanagement.models.PolicyIdName;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiPolicies;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiPoliciesCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiPoliciesGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiPoliciesGetResponse;

public final class WorkspaceApiPoliciesImpl implements WorkspaceApiPolicies {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceApiPoliciesImpl.class);

    private final WorkspaceApiPoliciesClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public WorkspaceApiPoliciesImpl(WorkspaceApiPoliciesClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<PolicyContract> listByApi(String resourceGroupName, String serviceName, String workspaceId,
        String apiId) {
        PagedIterable<PolicyContractInner> inner
            = this.serviceClient().listByApi(resourceGroupName, serviceName, workspaceId, apiId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyContractImpl(inner1, this.manager()));
    }

    public PagedIterable<PolicyContract> listByApi(String resourceGroupName, String serviceName, String workspaceId,
        String apiId, Context context) {
        PagedIterable<PolicyContractInner> inner
            = this.serviceClient().listByApi(resourceGroupName, serviceName, workspaceId, apiId, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyContractImpl(inner1, this.manager()));
    }

    public WorkspaceApiPoliciesGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName,
        String serviceName, String workspaceId, String apiId, PolicyIdName policyId, Context context) {
        return this.serviceClient()
            .getEntityTagWithResponse(resourceGroupName, serviceName, workspaceId, apiId, policyId, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String workspaceId, String apiId,
        PolicyIdName policyId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, workspaceId, apiId, policyId);
    }

    public Response<PolicyContract> getWithResponse(String resourceGroupName, String serviceName, String workspaceId,
        String apiId, PolicyIdName policyId, PolicyExportFormat format, Context context) {
        WorkspaceApiPoliciesGetResponse inner = this.serviceClient()
            .getWithResponse(resourceGroupName, serviceName, workspaceId, apiId, policyId, format, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new PolicyContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public PolicyContract get(String resourceGroupName, String serviceName, String workspaceId, String apiId,
        PolicyIdName policyId) {
        PolicyContractInner inner
            = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, apiId, policyId);
        if (inner != null) {
            return new PolicyContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<PolicyContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, String apiId, PolicyIdName policyId, PolicyContractInner parameters, String ifMatch,
        Context context) {
        WorkspaceApiPoliciesCreateOrUpdateResponse inner = this.serviceClient()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, apiId, policyId, parameters,
                ifMatch, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new PolicyContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public PolicyContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String apiId,
        PolicyIdName policyId, PolicyContractInner parameters) {
        PolicyContractInner inner = this.serviceClient()
            .createOrUpdate(resourceGroupName, serviceName, workspaceId, apiId, policyId, parameters);
        if (inner != null) {
            return new PolicyContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId,
        String apiId, PolicyIdName policyId, String ifMatch, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, serviceName, workspaceId, apiId, policyId, ifMatch, context);
    }

    public void delete(String resourceGroupName, String serviceName, String workspaceId, String apiId,
        PolicyIdName policyId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, apiId, policyId, ifMatch);
    }

    private WorkspaceApiPoliciesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
