// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceApiReleasesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiReleaseContractInner;
import com.azure.resourcemanager.apimanagement.models.ApiReleaseContract;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiReleases;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiReleasesCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiReleasesGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiReleasesGetResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiReleasesUpdateResponse;

public final class WorkspaceApiReleasesImpl implements WorkspaceApiReleases {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceApiReleasesImpl.class);

    private final WorkspaceApiReleasesClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public WorkspaceApiReleasesImpl(WorkspaceApiReleasesClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<ApiReleaseContract> listByService(String resourceGroupName, String serviceName,
        String workspaceId, String apiId) {
        PagedIterable<ApiReleaseContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName, workspaceId, apiId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiReleaseContractImpl(inner1, this.manager()));
    }

    public PagedIterable<ApiReleaseContract> listByService(String resourceGroupName, String serviceName,
        String workspaceId, String apiId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<ApiReleaseContractInner> inner = this.serviceClient()
            .listByService(resourceGroupName, serviceName, workspaceId, apiId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiReleaseContractImpl(inner1, this.manager()));
    }

    public WorkspaceApiReleasesGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName,
        String serviceName, String workspaceId, String apiId, String releaseId, Context context) {
        return this.serviceClient()
            .getEntityTagWithResponse(resourceGroupName, serviceName, workspaceId, apiId, releaseId, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String workspaceId, String apiId,
        String releaseId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, workspaceId, apiId, releaseId);
    }

    public Response<ApiReleaseContract> getWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, String apiId, String releaseId, Context context) {
        WorkspaceApiReleasesGetResponse inner = this.serviceClient()
            .getWithResponse(resourceGroupName, serviceName, workspaceId, apiId, releaseId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ApiReleaseContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ApiReleaseContract get(String resourceGroupName, String serviceName, String workspaceId, String apiId,
        String releaseId) {
        ApiReleaseContractInner inner
            = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, apiId, releaseId);
        if (inner != null) {
            return new ApiReleaseContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<ApiReleaseContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, String apiId, String releaseId, ApiReleaseContractInner parameters, String ifMatch,
        Context context) {
        WorkspaceApiReleasesCreateOrUpdateResponse inner = this.serviceClient()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, apiId, releaseId, parameters,
                ifMatch, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ApiReleaseContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ApiReleaseContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId,
        String apiId, String releaseId, ApiReleaseContractInner parameters) {
        ApiReleaseContractInner inner = this.serviceClient()
            .createOrUpdate(resourceGroupName, serviceName, workspaceId, apiId, releaseId, parameters);
        if (inner != null) {
            return new ApiReleaseContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<ApiReleaseContract> updateWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, String apiId, String releaseId, String ifMatch, ApiReleaseContractInner parameters,
        Context context) {
        WorkspaceApiReleasesUpdateResponse inner = this.serviceClient()
            .updateWithResponse(resourceGroupName, serviceName, workspaceId, apiId, releaseId, ifMatch, parameters,
                context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ApiReleaseContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ApiReleaseContract update(String resourceGroupName, String serviceName, String workspaceId, String apiId,
        String releaseId, String ifMatch, ApiReleaseContractInner parameters) {
        ApiReleaseContractInner inner = this.serviceClient()
            .update(resourceGroupName, serviceName, workspaceId, apiId, releaseId, ifMatch, parameters);
        if (inner != null) {
            return new ApiReleaseContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId,
        String apiId, String releaseId, String ifMatch, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, serviceName, workspaceId, apiId, releaseId, ifMatch, context);
    }

    public void delete(String resourceGroupName, String serviceName, String workspaceId, String apiId, String releaseId,
        String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, apiId, releaseId, ifMatch);
    }

    private WorkspaceApiReleasesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
