// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceApiSchemasClient;
import com.azure.resourcemanager.apimanagement.fluent.models.SchemaContractInner;
import com.azure.resourcemanager.apimanagement.models.SchemaContract;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiSchemas;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiSchemasGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiSchemasGetResponse;

public final class WorkspaceApiSchemasImpl implements WorkspaceApiSchemas {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceApiSchemasImpl.class);

    private final WorkspaceApiSchemasClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public WorkspaceApiSchemasImpl(WorkspaceApiSchemasClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<SchemaContract> listByApi(String resourceGroupName, String serviceName, String workspaceId,
        String apiId) {
        PagedIterable<SchemaContractInner> inner
            = this.serviceClient().listByApi(resourceGroupName, serviceName, workspaceId, apiId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SchemaContractImpl(inner1, this.manager()));
    }

    public PagedIterable<SchemaContract> listByApi(String resourceGroupName, String serviceName, String workspaceId,
        String apiId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<SchemaContractInner> inner = this.serviceClient()
            .listByApi(resourceGroupName, serviceName, workspaceId, apiId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SchemaContractImpl(inner1, this.manager()));
    }

    public WorkspaceApiSchemasGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName,
        String serviceName, String workspaceId, String apiId, String schemaId, Context context) {
        return this.serviceClient()
            .getEntityTagWithResponse(resourceGroupName, serviceName, workspaceId, apiId, schemaId, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String workspaceId, String apiId,
        String schemaId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, workspaceId, apiId, schemaId);
    }

    public Response<SchemaContract> getWithResponse(String resourceGroupName, String serviceName, String workspaceId,
        String apiId, String schemaId, Context context) {
        WorkspaceApiSchemasGetResponse inner = this.serviceClient()
            .getWithResponse(resourceGroupName, serviceName, workspaceId, apiId, schemaId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new SchemaContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public SchemaContract get(String resourceGroupName, String serviceName, String workspaceId, String apiId,
        String schemaId) {
        SchemaContractInner inner
            = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, apiId, schemaId);
        if (inner != null) {
            return new SchemaContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public SchemaContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String apiId,
        String schemaId, SchemaContractInner parameters) {
        SchemaContractInner inner = this.serviceClient()
            .createOrUpdate(resourceGroupName, serviceName, workspaceId, apiId, schemaId, parameters);
        if (inner != null) {
            return new SchemaContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public SchemaContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String apiId,
        String schemaId, SchemaContractInner parameters, String ifMatch, Context context) {
        SchemaContractInner inner = this.serviceClient()
            .createOrUpdate(resourceGroupName, serviceName, workspaceId, apiId, schemaId, parameters, ifMatch, context);
        if (inner != null) {
            return new SchemaContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId,
        String apiId, String schemaId, String ifMatch, Boolean force, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, serviceName, workspaceId, apiId, schemaId, ifMatch, force, context);
    }

    public void delete(String resourceGroupName, String serviceName, String workspaceId, String apiId, String schemaId,
        String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, apiId, schemaId, ifMatch);
    }

    private WorkspaceApiSchemasClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
