// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceBackendsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.BackendContractInner;
import com.azure.resourcemanager.apimanagement.models.BackendContract;
import com.azure.resourcemanager.apimanagement.models.BackendUpdateParameters;
import com.azure.resourcemanager.apimanagement.models.WorkspaceBackends;
import com.azure.resourcemanager.apimanagement.models.WorkspaceBackendsCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceBackendsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceBackendsGetResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceBackendsUpdateResponse;

public final class WorkspaceBackendsImpl implements WorkspaceBackends {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceBackendsImpl.class);

    private final WorkspaceBackendsClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public WorkspaceBackendsImpl(WorkspaceBackendsClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<BackendContract> listByWorkspace(String resourceGroupName, String serviceName,
        String workspaceId) {
        PagedIterable<BackendContractInner> inner
            = this.serviceClient().listByWorkspace(resourceGroupName, serviceName, workspaceId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BackendContractImpl(inner1, this.manager()));
    }

    public PagedIterable<BackendContract> listByWorkspace(String resourceGroupName, String serviceName,
        String workspaceId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<BackendContractInner> inner = this.serviceClient()
            .listByWorkspace(resourceGroupName, serviceName, workspaceId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BackendContractImpl(inner1, this.manager()));
    }

    public WorkspaceBackendsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, String backendId, Context context) {
        return this.serviceClient()
            .getEntityTagWithResponse(resourceGroupName, serviceName, workspaceId, backendId, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String workspaceId, String backendId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, workspaceId, backendId);
    }

    public Response<BackendContract> getWithResponse(String resourceGroupName, String serviceName, String workspaceId,
        String backendId, Context context) {
        WorkspaceBackendsGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, backendId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new BackendContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public BackendContract get(String resourceGroupName, String serviceName, String workspaceId, String backendId) {
        BackendContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, backendId);
        if (inner != null) {
            return new BackendContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<BackendContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, String backendId, BackendContractInner parameters, String ifMatch, Context context) {
        WorkspaceBackendsCreateOrUpdateResponse inner = this.serviceClient()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, backendId, parameters, ifMatch,
                context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new BackendContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public BackendContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId,
        String backendId, BackendContractInner parameters) {
        BackendContractInner inner
            = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, workspaceId, backendId, parameters);
        if (inner != null) {
            return new BackendContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<BackendContract> updateWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, String backendId, String ifMatch, BackendUpdateParameters parameters, Context context) {
        WorkspaceBackendsUpdateResponse inner = this.serviceClient()
            .updateWithResponse(resourceGroupName, serviceName, workspaceId, backendId, ifMatch, parameters, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new BackendContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public BackendContract update(String resourceGroupName, String serviceName, String workspaceId, String backendId,
        String ifMatch, BackendUpdateParameters parameters) {
        BackendContractInner inner
            = this.serviceClient().update(resourceGroupName, serviceName, workspaceId, backendId, ifMatch, parameters);
        if (inner != null) {
            return new BackendContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId,
        String backendId, String ifMatch, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, serviceName, workspaceId, backendId, ifMatch, context);
    }

    public void delete(String resourceGroupName, String serviceName, String workspaceId, String backendId,
        String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, backendId, ifMatch);
    }

    private WorkspaceBackendsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
