// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceCertificatesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.CertificateContractInner;
import com.azure.resourcemanager.apimanagement.models.CertificateContract;
import com.azure.resourcemanager.apimanagement.models.CertificateCreateOrUpdateParameters;
import com.azure.resourcemanager.apimanagement.models.WorkspaceCertificates;
import com.azure.resourcemanager.apimanagement.models.WorkspaceCertificatesCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceCertificatesGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceCertificatesGetResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceCertificatesRefreshSecretResponse;

public final class WorkspaceCertificatesImpl implements WorkspaceCertificates {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceCertificatesImpl.class);

    private final WorkspaceCertificatesClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public WorkspaceCertificatesImpl(WorkspaceCertificatesClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<CertificateContract> listByWorkspace(String resourceGroupName, String serviceName,
        String workspaceId) {
        PagedIterable<CertificateContractInner> inner
            = this.serviceClient().listByWorkspace(resourceGroupName, serviceName, workspaceId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CertificateContractImpl(inner1, this.manager()));
    }

    public PagedIterable<CertificateContract> listByWorkspace(String resourceGroupName, String serviceName,
        String workspaceId, String filter, Integer top, Integer skip, Boolean isKeyVaultRefreshFailed,
        Context context) {
        PagedIterable<CertificateContractInner> inner = this.serviceClient()
            .listByWorkspace(resourceGroupName, serviceName, workspaceId, filter, top, skip, isKeyVaultRefreshFailed,
                context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CertificateContractImpl(inner1, this.manager()));
    }

    public WorkspaceCertificatesGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName,
        String serviceName, String workspaceId, String certificateId, Context context) {
        return this.serviceClient()
            .getEntityTagWithResponse(resourceGroupName, serviceName, workspaceId, certificateId, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String workspaceId, String certificateId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, workspaceId, certificateId);
    }

    public Response<CertificateContract> getWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, String certificateId, Context context) {
        WorkspaceCertificatesGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, certificateId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new CertificateContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public CertificateContract get(String resourceGroupName, String serviceName, String workspaceId,
        String certificateId) {
        CertificateContractInner inner
            = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, certificateId);
        if (inner != null) {
            return new CertificateContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<CertificateContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, String certificateId, CertificateCreateOrUpdateParameters parameters, String ifMatch,
        Context context) {
        WorkspaceCertificatesCreateOrUpdateResponse inner = this.serviceClient()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, certificateId, parameters, ifMatch,
                context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new CertificateContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public CertificateContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId,
        String certificateId, CertificateCreateOrUpdateParameters parameters) {
        CertificateContractInner inner = this.serviceClient()
            .createOrUpdate(resourceGroupName, serviceName, workspaceId, certificateId, parameters);
        if (inner != null) {
            return new CertificateContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId,
        String certificateId, String ifMatch, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, serviceName, workspaceId, certificateId, ifMatch, context);
    }

    public void delete(String resourceGroupName, String serviceName, String workspaceId, String certificateId,
        String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, certificateId, ifMatch);
    }

    public Response<CertificateContract> refreshSecretWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, String certificateId, Context context) {
        WorkspaceCertificatesRefreshSecretResponse inner = this.serviceClient()
            .refreshSecretWithResponse(resourceGroupName, serviceName, workspaceId, certificateId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new CertificateContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public CertificateContract refreshSecret(String resourceGroupName, String serviceName, String workspaceId,
        String certificateId) {
        CertificateContractInner inner
            = this.serviceClient().refreshSecret(resourceGroupName, serviceName, workspaceId, certificateId);
        if (inner != null) {
            return new CertificateContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private WorkspaceCertificatesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
