// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.WorkspaceContractInner;
import com.azure.resourcemanager.apimanagement.models.WorkspaceContract;

public final class WorkspaceContractImpl
    implements WorkspaceContract, WorkspaceContract.Definition, WorkspaceContract.Update {
    private WorkspaceContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String displayName() {
        return this.innerModel().displayName();
    }

    public String description() {
        return this.innerModel().description();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public WorkspaceContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String workspaceId;

    private String createIfMatch;

    private String updateIfMatch;

    public WorkspaceContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    public WorkspaceContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getWorkspaces()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, this.innerModel(), createIfMatch,
                Context.NONE)
            .getValue();
        return this;
    }

    public WorkspaceContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getWorkspaces()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, this.innerModel(), createIfMatch,
                context)
            .getValue();
        return this;
    }

    WorkspaceContractImpl(String name, com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new WorkspaceContractInner();
        this.serviceManager = serviceManager;
        this.workspaceId = name;
        this.createIfMatch = null;
    }

    public WorkspaceContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    public WorkspaceContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getWorkspaces()
            .updateWithResponse(resourceGroupName, serviceName, workspaceId, updateIfMatch, this.innerModel(),
                Context.NONE)
            .getValue();
        return this;
    }

    public WorkspaceContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getWorkspaces()
            .updateWithResponse(resourceGroupName, serviceName, workspaceId, updateIfMatch, this.innerModel(), context)
            .getValue();
        return this;
    }

    WorkspaceContractImpl(WorkspaceContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.workspaceId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "workspaces");
    }

    public WorkspaceContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getWorkspaces()
            .getWithResponse(resourceGroupName, serviceName, workspaceId, Context.NONE)
            .getValue();
        return this;
    }

    public WorkspaceContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getWorkspaces()
            .getWithResponse(resourceGroupName, serviceName, workspaceId, context)
            .getValue();
        return this;
    }

    public WorkspaceContractImpl withDisplayName(String displayName) {
        this.innerModel().withDisplayName(displayName);
        return this;
    }

    public WorkspaceContractImpl withDescription(String description) {
        this.innerModel().withDescription(description);
        return this;
    }

    public WorkspaceContractImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
