// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceGlobalSchemasClient;
import com.azure.resourcemanager.apimanagement.fluent.models.GlobalSchemaContractInner;
import com.azure.resourcemanager.apimanagement.models.GlobalSchemaContract;
import com.azure.resourcemanager.apimanagement.models.WorkspaceGlobalSchemas;
import com.azure.resourcemanager.apimanagement.models.WorkspaceGlobalSchemasGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceGlobalSchemasGetResponse;

public final class WorkspaceGlobalSchemasImpl implements WorkspaceGlobalSchemas {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceGlobalSchemasImpl.class);

    private final WorkspaceGlobalSchemasClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public WorkspaceGlobalSchemasImpl(WorkspaceGlobalSchemasClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<GlobalSchemaContract> listByService(String resourceGroupName, String serviceName,
        String workspaceId) {
        PagedIterable<GlobalSchemaContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName, workspaceId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GlobalSchemaContractImpl(inner1, this.manager()));
    }

    public PagedIterable<GlobalSchemaContract> listByService(String resourceGroupName, String serviceName,
        String workspaceId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<GlobalSchemaContractInner> inner = this.serviceClient()
            .listByService(resourceGroupName, serviceName, workspaceId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GlobalSchemaContractImpl(inner1, this.manager()));
    }

    public WorkspaceGlobalSchemasGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName,
        String serviceName, String workspaceId, String schemaId, Context context) {
        return this.serviceClient()
            .getEntityTagWithResponse(resourceGroupName, serviceName, workspaceId, schemaId, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String workspaceId, String schemaId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, workspaceId, schemaId);
    }

    public Response<GlobalSchemaContract> getWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, String schemaId, Context context) {
        WorkspaceGlobalSchemasGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, schemaId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new GlobalSchemaContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public GlobalSchemaContract get(String resourceGroupName, String serviceName, String workspaceId, String schemaId) {
        GlobalSchemaContractInner inner
            = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, schemaId);
        if (inner != null) {
            return new GlobalSchemaContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public GlobalSchemaContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId,
        String schemaId, GlobalSchemaContractInner parameters) {
        GlobalSchemaContractInner inner
            = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, workspaceId, schemaId, parameters);
        if (inner != null) {
            return new GlobalSchemaContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public GlobalSchemaContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId,
        String schemaId, GlobalSchemaContractInner parameters, String ifMatch, Context context) {
        GlobalSchemaContractInner inner = this.serviceClient()
            .createOrUpdate(resourceGroupName, serviceName, workspaceId, schemaId, parameters, ifMatch, context);
        if (inner != null) {
            return new GlobalSchemaContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId,
        String schemaId, String ifMatch, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, serviceName, workspaceId, schemaId, ifMatch, context);
    }

    public void delete(String resourceGroupName, String serviceName, String workspaceId, String schemaId,
        String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, schemaId, ifMatch);
    }

    private WorkspaceGlobalSchemasClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
